// This panel contains 

 /********************************************************************
     
   1. Library files and Dir
   2. Include files and Dir
 
 **********************************************************************/

  import java.awt.*;
  import java.awt.event.*;
  import javax.swing.*;
  import javax.swing.event.*;
  import javax.swing.filechooser.*;
  import java.io.*;
//  import com.util.myjava.*;  // for MovingCanvas

  public class FileDetailsPanel extends JPanel implements ActionListener,MouseListener
  {

   private JTextArea LibDirArea,LibFileArea;
   private JTextArea IncDirArea,IncFileArea;

   private JScrollPane LibDirSPane,LibFileSPane;
   private JScrollPane IncDirSPane,IncFileSPane;
 
   private JButton LibBrowseBtn,IncBrowseBtn;

    
   private int IncludeFileNumbers;
   private java.util.Vector IncludeFileNames;

   private int LibraryFileNumbers;
   private java.util.Vector LibraryFileNames;
 
   private int IncludeDirNumbers;
   private java.util.Vector IncludeDirNames;

   private int LibraryDirNumbers;
   private java.util.Vector LibraryDirNames;
   private MovingCanvas mc;


public  FileDetailsPanel()
   {
   setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
  
   JPanel LibDirPane = new JPanel();
   JPanel IncDirPane = new JPanel();
   JPanel LibFilePane = new JPanel();
   JPanel IncFilePane = new JPanel();
    
   LibDirPane.setLayout(new BoxLayout(LibDirPane,BoxLayout.X_AXIS));
   LibDirPane.setBorder(BorderFactory.createTitledBorder("Library Dir"));
   
   IncDirPane.setLayout(new BoxLayout(IncDirPane,BoxLayout.X_AXIS));
   IncDirPane.setBorder(BorderFactory.createTitledBorder("Include Dir"));
  
   LibFilePane.setLayout(new BoxLayout(LibFilePane,BoxLayout.X_AXIS));
   LibFilePane.setBorder(BorderFactory.createTitledBorder("Library File"));
  
   IncFilePane.setLayout(new BoxLayout(IncFilePane,BoxLayout.X_AXIS));
   IncFilePane.setBorder(BorderFactory.createTitledBorder("Include File"));


    mc = new MovingCanvas("",new Dimension(250,25),this.getSize().width/2,10); 
   mc.setFont(new Font("Serif",Font.BOLD,14));
   mc.setColor(Color.yellow);


   add(new JLabel(" "));
   add(LibDirPane);
   
   add(new JLabel(" "));
   add(LibFilePane);
  
   add(new JLabel(" "));
   add(IncDirPane);
  
   add(new JLabel(" "));
   add(IncFilePane);
 
   add(mc);
   mc.setVisible(false);
   mc.delMsgs();
   mc.stop();


   LibDirArea = new JTextArea();
   LibDirSPane = new JScrollPane(LibDirArea);
   LibDirArea.addMouseListener(this);


   LibDirArea.setMaximumSize(new Dimension(750,80));
   LibDirSPane.setMaximumSize(new Dimension(750,80));
   LibDirSPane.setSize(LibDirArea.getMaximumSize());
   LibDirSPane.setPreferredSize(LibDirArea.getMaximumSize());

   //System.out.println(" max "+ LibDirArea.getMaximumSize()); 
   //System.out.println("min "+ LibDirArea.getMinimumSize());
   //System.out.println(" size "+ LibDirArea.getSize());

   
   LibFileArea = new JTextArea();
   LibFileSPane = new JScrollPane(LibFileArea);
   LibFileArea.addMouseListener(this);
   
   LibFileArea.setMaximumSize(new Dimension(750,80));
   LibFileSPane.setMaximumSize(new Dimension(750,80));
   LibFileSPane.setSize(LibFileArea.getMaximumSize());
   LibFileSPane.setPreferredSize(LibFileArea.getMaximumSize());
   //LibFileSPane.setPreferredSize(new Dimension(150,80));

   IncDirArea = new JTextArea();
   IncDirSPane = new JScrollPane(IncDirArea);
   IncDirArea.addMouseListener(this);

   IncDirArea.setMaximumSize(new Dimension(750,80));
   IncDirSPane.setMaximumSize(new Dimension(750,80));
   IncDirSPane.setSize(IncDirArea.getMaximumSize());
   IncDirSPane.setPreferredSize(IncDirArea.getMaximumSize());
   //IncDirSPane.setPreferredSize(new Dimension(150,80));
   
   IncFileArea = new JTextArea();
   IncFileSPane = new JScrollPane(IncFileArea);
   IncFileArea.addMouseListener(this);
   

   IncFileArea.setMaximumSize(new Dimension(750,80));
   IncFileSPane.setMaximumSize(new Dimension(750,80));
   IncFileSPane.setSize(IncFileArea.getMaximumSize());
   IncFileSPane.setPreferredSize(IncFileArea.getMaximumSize());
   //IncFileSPane.setPreferredSize(new Dimension(150,80));

 
    LibDirArea.setFont(new Font("Serif",Font.BOLD,11));
    LibFileArea.setFont(new Font("Serif",Font.BOLD,11));
    IncDirArea.setFont(new Font("Serif",Font.BOLD,11));
    IncFileArea.setFont(new Font("Serif",Font.BOLD,11));

 
   LibBrowseBtn = new JButton("Browse...");
   IncBrowseBtn = new JButton("Browse...");

   IncludeFileNames = new java.util.Vector();
   LibraryFileNames = new java.util.Vector();
   IncludeDirNames = new java.util.Vector();
   LibraryDirNames = new java.util.Vector();



   LibDirPane.add(new JLabel("Library  Dir"));
   LibDirPane.add(new JLabel("   "));
   LibDirPane.add(LibDirSPane);
   LibDirPane.add(new JLabel("                            "));
   
   LibFilePane.add(new JLabel("Library File"));
   LibFilePane.add(new JLabel("   "));
   LibFilePane.add(LibFileSPane);
   LibFilePane.add(new JLabel("   "));
   LibFilePane.add(LibBrowseBtn);
   LibFilePane.add(new JLabel("   "));
 

   IncDirPane.add(new JLabel("Include  Dir"));
   IncDirPane.add(new JLabel("   "));
   IncDirPane.add(IncDirSPane);
   IncDirPane.add(new JLabel("                            "));
   
   IncFilePane.add(new JLabel("Include File"));
   IncFilePane.add(new JLabel("   "));
   IncFilePane.add(IncFileSPane);
   IncFilePane.add(new JLabel("   "));
   IncFilePane.add(IncBrowseBtn);
   IncFilePane.add(new JLabel("   "));
 
 LibBrowseBtn.addActionListener(this);

 IncBrowseBtn.addActionListener(this);

  } // end of FileDetailsPanel() constructor


 public void mouseClicked(MouseEvent me)
 {
  mc.delMsgs();
  mc.stop();
  mc.setVisible(false);

  File f = null;
  String str = null;
  int Num = 0;

  // if source is LibDir
 
   if(me.getSource() == LibDirArea);  // check other areas
    {
     Num = getLibraryFileNumbers();  // check LibFile
     for(int i = 0;i<Num;i++)
      {
       str = ((String)LibraryFileNames.elementAt(i)).trim(); 
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isFile())   // if NotFile
        {mc.setVisible(true);
         mc.addMsg("lf check if " + str + " is file or not " );
        }
       }
      }  
     Num = getIncludeDirNumbers();  // check IncDir 
     for(int i = 0;i<Num;i++)
      {
       str = ((String)IncludeDirNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isDirectory())   // if NotDir
        {mc.setVisible(true);
         mc.addMsg(" id check if "+  str + " is Directory or not " );
        }
       }
      } 
     Num = getIncludeFileNumbers();  // check IncFile
     for(int i = 0;i<Num;i++)
      {
       str = ((String)IncludeFileNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isFile())   // if NotFile
        {mc.setVisible(true);
         mc.addMsg(" if check if " + str + " is file or not " );
        }
       }
      }
	
    }

   // if source is LibFileArea
     if(me.getSource() == LibFileArea);  // check other areas
    {
     Num = getLibraryDirNumbers();  // check LibDir
     for(int i = 0;i<Num;i++)
      {
       str = ((String)LibraryDirNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isDirectory())   // if NotDir
        {mc.setVisible(true);
         mc.addMsg("ld check if " + str + " is Directory or not " );
        }
       }
      }
     Num = getIncludeDirNumbers();  // check IncDir
     for(int i = 0;i<Num;i++)
      {
       str = ((String)IncludeDirNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isDirectory())   // if NotDir
        {mc.setVisible(true);
         mc.addMsg(" id check if "+  str + " is Directory or not " );
        }
       }
      }
     Num = getIncludeFileNumbers();  // check IncFile
     for(int i = 0;i<Num;i++)
      {
       str = ((String)IncludeFileNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isFile())   // if NotFile
        {mc.setVisible(true);
         mc.addMsg(" if check if " + str + " is file or not " );
        }
       }
      }

    }

  // if source is IncDirArea
 if(me.getSource() == IncDirArea);  // check other areas
    {
     Num = getIncludeFileNumbers();  // check IncFile
     for(int i = 0;i<Num;i++)
      {
       str = ((String)IncludeFileNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isFile())   // if NotFile
        {mc.setVisible(true);
         mc.addMsg(" if check if " + str + " is file or not " );
        }
       }
      }
     Num = getLibraryDirNumbers();  // check LibDir
     for(int i = 0;i<Num;i++)
      {
       str = ((String)LibraryDirNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isDirectory())   // if NotDir
        {mc.setVisible(true);
         mc.addMsg(" ld check if "+  str + " is Directory or not " );
        }
       }
      }
     Num = getLibraryFileNumbers();  // check LibFile
     for(int i = 0;i<Num;i++)
      {
       str = ((String)LibraryFileNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isFile())   // if NotFile
        {mc.setVisible(true);
         mc.addMsg(" lf check if " + str + " is file or not " );
        }
       }
      }

    }
 
   // if source is IncFileArea
 if(me.getSource() == IncFileArea);  // check other areas
    {
     Num = getIncludeDirNumbers();  // check IncDir
     for(int i = 0;i<Num;i++)
      {
       str = ((String)IncludeDirNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isDirectory())   // if NotDir
        {mc.setVisible(true);
         mc.addMsg(" id check if " + str + " is file or not " );
        }
       }
      }
     Num = getLibraryDirNumbers();  // check LibDir
     for(int i = 0;i<Num;i++)
      {
       str = ((String)LibraryDirNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isDirectory())   // if NotDir
        {mc.setVisible(true);
         mc.addMsg(" ld check if "+  str + " is Directory or not " );
        }
       }
      }
     Num = getLibraryFileNumbers();  // check LibFile
     for(int i = 0;i<Num;i++)
      {
       str = ((String)LibraryFileNames.elementAt(i)).trim();
       if(!str.equals(""))
       {
        f = new File(str);
       if(!f.isFile())   // if NotFile
        {mc.setVisible(true);
         mc.addMsg(" lf check if " + str + " is file or not " );
        }
       }
      }

    }
     mc.start();

 }
 public void mouseEntered(MouseEvent me)
 {//System.out.println(me.getSource());
 }
 public void mouseExited(MouseEvent me)
 {//System.out.println(me.getSource());
 }
 public void mousePressed(MouseEvent me)
 {//System.out.println(me.getSource());
 }
 public void mouseReleased(MouseEvent me)
 {//System.out.println(me.getSource());
 }

 public void actionPerformed(ActionEvent ae)
 {
  if(ae.getSource() == LibBrowseBtn)
   {
    JFileChooser fc = new JFileChooser();
    int returnval = fc.showOpenDialog(this);
    if(returnval == JFileChooser.APPROVE_OPTION)
    {
     File file = fc.getSelectedFile();
     String str = LibFileArea.getText();
     if(str.equals(""))
       LibFileArea.setText(file.toString());   
     else
       LibFileArea.setText(LibFileArea.getText()+"\n"+file.toString());   
    }
  } 

 if(ae.getSource() == IncBrowseBtn)
   {
    JFileChooser fc = new JFileChooser();
    int returnval = fc.showOpenDialog(this);
    if(returnval == JFileChooser.APPROVE_OPTION)
    {
     File file = fc.getSelectedFile();
     String str = IncFileArea.getText();
     if(str.equals(""))
         IncFileArea.setText(file.toString());   
     else
         IncFileArea.setText(IncFileArea.getText()+"\n"+file.toString());   
    }

   }



 } // end of actionPerformed()


// Include file related Methods

int getIncludeFileNumbers()
 {
  String in = IncFileArea.getText();
  if(in.equals(""))
   {
    IncludeFileNames = null;
    IncludeFileNumbers = 0;
    return 0; 
   }
  int Count = 1;
  int startIndex = 0;
  java.util.Vector Names = new java.util.Vector();


 if(in.lastIndexOf('\n') == (in.length()-1))
  {
    String newin = in.substring(0,in.length()-1);
    in = newin;
  }

  for(int i = 0;i<in.length();i++)
   {
     if(in.charAt(i) == '\n')
      {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
       Count++;
      }
     if(i == in.length()-1)
      Names.addElement(in.substring(startIndex));
    }
  IncludeFileNames = Names;
  IncludeFileNumbers = Count;
  return Count;
 } // end of getIncludeFileNumbers()  method

 java.util.Vector getIncludeFileNames()
  {
   return IncludeFileNames;
   }

 String getIncludeFileName(int n)
 {
  // n should be less than FunctionNumbers;

  return ((String)IncludeFileNames.elementAt(n));

 }

  void setIncludeFileName(java.util.Enumeration names)
  {
   String str;
   int i = 0;
   while(names.hasMoreElements())
   {
    str = (String)names.nextElement();
     if(i ==0)
        IncFileArea.setText(str);
     else
        IncFileArea.setText(IncFileArea.getText()+"\n"+str);

     IncludeFileNames.insertElementAt(str,i);
    i++;
   }

  }  // end of setIncludeFileName




// Include Dir related Methods

int getIncludeDirNumbers()
 {
  String in = IncDirArea.getText();
  if(in.equals(""))
   {
    IncludeDirNames = null;
    IncludeDirNumbers = 0;
    return 0; 
   }
  int Count = 1;
  int startIndex = 0;
  java.util.Vector Names = new java.util.Vector();


 if(in.lastIndexOf('\n') == (in.length()-1))
  {
    String newin = in.substring(0,in.length()-1);
    in = newin;
  }

  for(int i = 0;i<in.length();i++)
   {
     if(in.charAt(i) == '\n')
      {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
       Count++;
      }
     if(i == in.length()-1)
      Names.addElement(in.substring(startIndex));
    }
  IncludeDirNames = Names;
  IncludeDirNumbers = Count;
  return Count;
 } // end of getIncludeFileNumbers()  method

 java.util.Vector getIncludeDirNames()
  {
   return IncludeDirNames;
   }

 String getIncludeDirName(int n)
 {
  // n should be less than FunctionNumbers;

  return ((String)IncludeDirNames.elementAt(n));

 }

  void setIncludeDirName(java.util.Enumeration names)
  {
   String str;
   int i = 0;
   while(names.hasMoreElements())
   {
    str = (String)names.nextElement();
     if(i ==0)
        IncDirArea.setText(str);
     else
        IncDirArea.setText(IncDirArea.getText()+"\n"+str);

     IncludeDirNames.insertElementAt(str,i);
    i++;
   }

  }  // end of setIncludeDirName


// Library file related Methods

int getLibraryFileNumbers()
 {
  String in = LibFileArea.getText();
  if(in.equals(""))
   {
    LibraryFileNames = null;
    LibraryFileNumbers = 0;
    return 0; 
   }
  int Count = 1;
  int startIndex = 0;
  java.util.Vector Names = new java.util.Vector();


 if(in.lastIndexOf('\n') == (in.length()-1))
  {
    String newin = in.substring(0,in.length()-1);
    in = newin;
  }

  for(int i = 0;i<in.length();i++)
   {
     if(in.charAt(i) == '\n')
      {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
       Count++;
      }
     if(i == in.length()-1)
      Names.addElement(in.substring(startIndex));
    }
  LibraryFileNames = Names;
  LibraryFileNumbers = Count;
  return Count;
 } // end of getIncludeFileNumbers()  method

 java.util.Vector getLibraryFileNames()
  {
   return LibraryFileNames;
   }

 String getLibraryFileName(int n)
 {
  // n should be less than FunctionNumbers;

  return ((String)LibraryFileNames.elementAt(n));

 }

 void setLibraryFileName(java.util.Enumeration names)
  {
   String str;
   int i = 0;
   while(names.hasMoreElements())
   {
    str = (String)names.nextElement();
     if(i ==0)
        LibFileArea.setText(str);
     else
        LibFileArea.setText(LibFileArea.getText()+"\n"+str);

     LibraryFileNames.insertElementAt(str,i);
    i++;
   }

  }  // end of setLibraryFileName


// Library Dir related Methods

int getLibraryDirNumbers()
 {
  String in = LibDirArea.getText();
  if(in.equals(""))
   {
    LibraryDirNames = null;
    LibraryDirNumbers = 0;
    return 0; 
   }
  int Count = 1;
  int startIndex = 0;
  java.util.Vector Names = new java.util.Vector();


 if(in.lastIndexOf('\n') == (in.length()-1))
  {
    String newin = in.substring(0,in.length()-1);
    in = newin;
  }

  for(int i = 0;i<in.length();i++)
   {
     if(in.charAt(i) == '\n')
      {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
       Count++;
      }
     if(i == in.length()-1)
      Names.addElement(in.substring(startIndex));
    }
  LibraryDirNames = Names;
  LibraryDirNumbers = Count;
  return Count;
 } // end of getIncludeFileNumbers()  method

 java.util.Vector getLibraryDirNames()
  {
   return LibraryDirNames;
   }

 String getLibraryDirName(int n)
 {
  // n should be less than FunctionNumbers;

  return ((String)LibraryDirNames.elementAt(n));

 }

   void setLibraryDirName(java.util.Enumeration names)
  {
   String str;
   int i = 0;
   while(names.hasMoreElements())
   {
    str = (String)names.nextElement();
     if(i ==0)
        LibDirArea.setText(str);
     else
        LibDirArea.setText(LibDirArea.getText()+"\n"+str);

     LibraryDirNames.insertElementAt(str,i);
    i++;
   }

  }  // end of setLibraryDirName

  void initialiseFileDetailsPanel()
 {
  LibDirArea.setText("");
  LibFileArea.setText("");
  IncDirArea.setText("");
  IncFileArea.setText("");
  mc.delMsgs();
  mc.setVisible(false);
 }  


} // end of FileDetailsPanel Class

