import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

public class CustomFileFilter extends FileFilter {

   String ext = null;
    public CustomFileFilter(String ext)
    {
       this.ext = ext; 
    }   
 
    // Accept all directories and xml Files.
    public boolean accept(File f) 
    {
        if (f.isDirectory()) {
            return true;
        }

        String extension = getExtension(f);
        if (extension != null) {
            if (extension.equalsIgnoreCase(ext)) 
              return true;
            else
             return false;
            
        }

        return false;
    }
    
    // The description of this filter
    public String getDescription() {
        if(ext.equals("xmlpdf"))
         return ext + " Files";
        else
         return "nspdf & xmlpdf Files";
    }

  public String getExtention()
  {
   return ext;
   }

  public String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }

  

}
