/*****************************************************************

This Panel contains just one Text area that is used to write the 
code 


****************************************************************/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//import com.util.myjava.*;  // to import CustomLayout


public class CodePanel extends JPanel implements ActionListener
{
 JTextArea CodeArea;
 JScrollPane CodePane;
 JLabel TitleLabel;
 CFCSPanel cfc;
 JPanel toolsPanel;
 JButton[] tools;
 String IntialCodeStr = "/** \n write the main() function of the c code here \n for e.g. if the main() function looks like \n main() \n { \n printf(\"Hello World \\n\"); \n } \n write \n printf(\"Hello World\\n\"); \n in this area \n If your code would contain locaal variables and Toolbox Variables for e.g. \n int m; \n m = 3; \n A.rows = m; \n In this code, m is a local variable and A.rows is a ToolBox Variables  **/ \n\n\n ";


 JPopupMenu popup ;
 JMenuItem cut = new JMenuItem("Cut");
 JMenuItem copy = new JMenuItem("Copy");
 JMenuItem paste = new JMenuItem("Paste");
 JMenuItem select = new JMenuItem("Select All");
 CustomLayout cl = null;


  public CodePanel(CFCSPanel cfc)
  {
  this.cfc = cfc;
  toolsPanel = new JPanel();
  tools = new JButton[2];

  setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));

  CodeArea = new JTextArea(IntialCodeStr);
  CodeArea.setFont(new Font("Serif",Font.BOLD,14));

  CodePane = new JScrollPane(CodeArea);
  CodePane.setPreferredSize(new Dimension(250,250));


  TitleLabel = new JLabel("Please Enter the Code in the Text Area");

  add(new JScrollPane(toolsPanel));

  add(new JLabel(" "));

  add(TitleLabel);
  add(CodePane);
  
  add(new JLabel(" "));

 popup = new JPopupMenu();
 

 popup.add(cut);
 cut.addActionListener(this);
 popup.add(copy);
 copy.addActionListener(this);
 popup.add(paste);
 paste.addActionListener(this);
 popup.addSeparator();
 popup.add(select);
 select.addActionListener(this);

 cut.setEnabled(false);
 copy.setEnabled(false);
 //paste.setEnabled(false);

  
 
// an inner class PopupListener that extends MouseAdapter

  class PopupListener extends MouseAdapter
  {
     public void mousePressed (MouseEvent e)
     {
      if(e.isPopupTrigger())
      {
       if(CodeArea.getSelectedText() != null)
         { cut.setEnabled(true);
          copy.setEnabled(true);
         } 
       popup.show(e.getComponent(),e.getX(),e.getY());
      }
     }

    public void mouseReleased(MouseEvent e)
     {
      if(e.isPopupTrigger())
      popup.show(e.getComponent(),e.getX(),e.getY());
     }

  } // end of inner class PopupListener

 MouseListener popupListener = new PopupListener();
 CodeArea.addMouseListener(popupListener);
 CodePane.addMouseListener(popupListener);




} // end of CodePanel() Constructor

public void UpdatePanel()
{

java.util.Vector des = cfc.getDescription();
java.util.Vector inputs = cfc.getInputNames();
java.util.Vector outputs = cfc.getOutputNames();

int Size = des.size();

tools = new JButton[Size];
toolsPanel.removeAll();
 
 if(inputs.size()+outputs.size() < 10)
  cl = new CustomLayout(new Dimension(6,10)); // 6 as max # of var for Sparsematrix
 else
  cl = new CustomLayout(new Dimension(6,inputs.size()+outputs.size()));

toolsPanel.setLayout(cl);
int x=0,y=0;  // for proper adding of buttons on panel

 String str = null;
 for(int i = 0;i<Size;i++)
  {
   str = ((JLabel)des.elementAt(i)).getText();
   
   tools[i] = new JButton(str);
   tools[i].addActionListener(this);

   if(i > 0)
   {
     String one = tools[i-1].getText();
     String two = tools[i].getText();
  
  if(two.substring(0,two.indexOf('.')).equals(one.substring(0,one.indexOf('.'))))
       x++;
    else
      {y++;x=0;}
   } 
   toolsPanel.add(tools[i],new Rectangle(x,y,1,1));
   
  } // end of for 
}


 public void actionPerformed(ActionEvent ae)
 {

  if(ae.getSource() == cut)
    CodeArea.cut();
  else if(ae.getSource() == copy)
    CodeArea.copy();

  else if(ae.getSource() == paste)
    CodeArea.paste();

  else if(ae.getSource() == select)
    CodeArea.selectAll();
 
  else
    {
      JButton tempButton = (JButton)ae.getSource();
      CodeArea.insert(tempButton.getText(),CodeArea.getCaretPosition());
   }

 }


 String getCode()
 {
  String code = CodeArea.getText();
  int sequenceSize = cfc.getSequenceSize();
  Arguments a = cfc.getArguments();
 
  String nsarg = null;
 
  for(int i = 0;i<sequenceSize;i++)
  {
    nsarg = "@" + a.getNetsolveArg(i)+"@";
   if(!a.getUserArg(i).endsWith(".val")) // means its not a ptr
      nsarg = "*" + nsarg;
  
   code = replaceString(a.getUserArg(i),nsarg,code);
   } 
  return code;
 }

 private String replaceString(String oldStr, String newStr, String inputStr)
 {
    String outputStr = "";

    for (int i=0; i<inputStr.length(); i++) 
     {
      if (!(inputStr.regionMatches(true, i, oldStr, 0, oldStr.length())))
        outputStr += inputStr.charAt(i);
      else 
       {
        outputStr += newStr;
        i += oldStr.length()-1;
       }
     }
    return outputStr;
  } // end of replaceString


 void setCode(ProblemDescription pd)
 {
  Arguments a = pd.getArguments();
  int sequenceSize = a.getSize();
  String code = pd.getCode();

  String nsarg = null;
  for(int i = 0;i<sequenceSize;i++)
  {
   nsarg = "@" + a.getNetsolveArg(i)+"@";
   if(!a.getUserArg(i).endsWith(".val")) // means its not a ptr
      nsarg = "*" + nsarg;

   code = replaceString(nsarg,a.getUserArg(i),code);
   }

 CodeArea.setText(code);
 }




}// end of CodePanel Class





