import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
//import com.util.myjava.*;  // for CustomLayout


// This panel is added to CFCallingSequencePanel at Right hand side

public class CFCSPanel extends JPanel implements ActionListener
{
 InputPanel ip;
 OutputPanel op;
 private int SequenceSize = 0;
 private int NewSequenceSize = 0;
 private int TotalInputs;
 private int TotalOutputs;
 private java.util.Vector SequenceCBox; 
 private java.util.Vector DescriptionVector; 
 int SelectionArray[];
 CustomLayout cl = null;
 boolean UpdateCalled = false;
 JPanel sequencePanel = null;

 JLabel StatusLabel;
 JTextArea StatusArea;
 JScrollPane StatusPane;
  private String problemName = null;
  java.util.Vector inputNames;
  java.util.Vector outputNames;
 
  public CFCSPanel(InputPanel ip, OutputPanel op)
  {
   this.ip = ip;
   this.op = op;
   problemName = ip.problemName;

   SequenceCBox = new java.util.Vector();
   DescriptionVector = new java.util.Vector();
   sequencePanel = new JPanel();
      StatusLabel = new JLabel("INPUT/OUTPUT Status");
   StatusArea = new JTextArea("Status");
   StatusArea.setFont(new Font("Serif",Font.BOLD,12));
   StatusArea.setEditable(false);
   StatusPane = new JScrollPane(StatusArea);
   StatusArea.setMaximumSize(new Dimension(750,225));
   StatusPane.setMaximumSize(new Dimension(750,225));
   StatusArea.setSize(StatusArea.getMaximumSize());
   StatusPane.setPreferredSize(new Dimension(250,StatusArea.getMaximumSize().height));


   setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
   add(StatusLabel);
   add(StatusPane);
   add(sequencePanel);

   sequencePanel.setLayout(new CustomLayout(new Dimension(1,3)));
   
    sequencePanel.add(new JLabel("Original Position"),new Rectangle(0,0,1,1));
    sequencePanel.add(new JLabel("Description "),new Rectangle(1,0,2,1));
    sequencePanel.add(new JLabel("New Position"),new Rectangle(3,0,1,1));
   }

  public void UpdatePanel()
  {
 
   problemName = ip.problemName;

    TotalInputs = ip.getInputNumbers();
    TotalOutputs = op.getOutputNumbers();
    String str;
    NewSequenceSize = getSequenceSize();

    if(NewSequenceSize == 0)
      return;
   if(NewSequenceSize < 20)
     cl = new CustomLayout(new Dimension(4, 20));  // 20 just to have proper grid size
   else
     cl = new CustomLayout(new Dimension(4, NewSequenceSize));  // else # of inputs to have grid size

    SelectionArray = new int[NewSequenceSize];
   
    if(!UpdateCalled)  // means update is not called again
      sequencePanel.setLayout(cl); // if called then dont setLayout
 
    if(SequenceSize > NewSequenceSize)
    { sequencePanel.removeAll();
     SequenceSize = 0;
    }

    String[] SequenceList = new String[NewSequenceSize];

    for(int i= 0;i<NewSequenceSize;i++)
       SequenceList[i] = new Integer(i+1).toString();
     sequencePanel.add(new JLabel("Original Position"),new Rectangle(0,0,1,1));
    sequencePanel.add(new JLabel("Description "),new Rectangle(1,0,2,1));
    sequencePanel.add(new JLabel("New Position"),new Rectangle(3,0,1,1));
 
    for(int i =SequenceSize;i<NewSequenceSize;i++)
    {
     str = (i+1) + " ";
     sequencePanel.add(new JLabel(str),new Rectangle(0,i+1,1,1)); 
     
     DescriptionVector.addElement(new JLabel("Some Name")); 
     sequencePanel.add((JLabel)DescriptionVector.elementAt(i),new Rectangle(1,i+1,2,1));
      
     SequenceCBox.addElement(new JComboBox(SequenceList));
     sequencePanel.add((JComboBox)SequenceCBox.elementAt(i),new Rectangle(3,i+1,1,1));
     ((JComboBox)SequenceCBox.elementAt(i)).addActionListener(this);
     ((JComboBox)SequenceCBox.elementAt(i)).setSelectedIndex(i);
    } 

    for(int i= 0;i<SequenceSize;i++)
     for(int j = SequenceSize;j<NewSequenceSize;j++)
    ((JComboBox)SequenceCBox.elementAt(i)).addItem(new Integer(j+1).toString());
  
    int flag = SequenceSize;
    SequenceSize = NewSequenceSize;

   if(NewSequenceSize > flag)
   {
     UpdateCalled = true; //just a flag to check if update called or not
     UpdatePanel();
   }

// sets the proper description for each Calling seq. argument 
  setDescription();
  DescriptionVector.setSize(getSequenceSize());

// set the status ie the CF calling example  
 setStatus();


  } // end of UpdatePanel()

public void setStatus()
{
 StringBuffer sb = new StringBuffer("\t\tCalling NetSolve from C & Fortran\n");
 sb.append("\t\tBlocking call for problem " + problemName );
 sb.append("\n\nC call :  status = netsl('" + problemName + "()' " );

 for(int i = 0;i<SequenceSize;i++)
   sb.append(", "+((JLabel)DescriptionVector.elementAt(i)).getText());

  sb.append(")");
 
 sb.append("\n\nFortran call : FNETSL('" + problemName.toUpperCase()+ "()', STATUS " );
 for(int i = 0;i<SequenceSize;i++)
   sb.append(", "+((JLabel)DescriptionVector.elementAt(i)).getText().toUpperCase());

 sb.append(")");

  StatusArea.setText(sb.toString());


}

 void setDescription()
 {
  inputNames = ip.getInputNames();
  outputNames = op.getOutputNames();
  
  int e = 0;   // counter
  int Objecttype;
 for(int i = 0;i<TotalInputs;i++)
 {
  Objecttype = ip.getObjectType(i);
  switch(Objecttype)
  {
   case 3 :   // scalar
           ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".val");  
            e++;
            break;

    case 2 :  // Vector
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".val");  
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(inputNames.elementAt(i)+".rows"); 
            e += 2;
            break;
     
     case 1:  // Matrix
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".val");  
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(inputNames.elementAt(i)+".rows");  
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(inputNames.elementAt(i)+".cols"); 
            ((JLabel)DescriptionVector.elementAt(e+3)).setText(inputNames.elementAt(i)+".leading"); 
            e += 4;
            break;

     case 6 : // String
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".val");
            e++;
            break;
       
     case 9:  // SparseMatrix
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".val");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(inputNames.elementAt(i)+".rows");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(inputNames.elementAt(i)+".cols");
            ((JLabel)DescriptionVector.elementAt(e+3)).setText(inputNames.elementAt(i)+".nzeros");
            ((JLabel)DescriptionVector.elementAt(e+4)).setText(inputNames.elementAt(i)+".col_index");
            ((JLabel)DescriptionVector.elementAt(e+5)).setText(inputNames.elementAt(i)+".row_ptr");
            e += 6;
            break;
          
     case 5:  //  File
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".filename");
            e++;
            break;
          
     case 4: // UPF
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".language");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(inputNames.elementAt(i)+".filename");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(inputNames.elementAt(i)+".functionname");
             e += 3;
            break;
     case 8: //String List
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".stringcount");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(inputNames.elementAt(i)+".stringname");
             e += 2;
             break;
         
     case  7: // PackedFiles
            ((JLabel)DescriptionVector.elementAt(e)).setText(inputNames.elementAt(i)+".filecount");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(inputNames.elementAt(i)+".filenames");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(inputNames.elementAt(i)+".defaultprefix");
           e += 3;
           break;

     
   }  // end of switch
 }    // end of for  TotalInputs

 for(int i = 0;i<TotalOutputs;i++)
 {
  Objecttype = op.getObjectType(i);
  switch(Objecttype)
  {

  case 3 :   // scalar
           ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".val");
            e++;
            break;

    case 2 :  // Vector
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".val");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(outputNames.elementAt(i)+".rows");
            e += 2;
            break;
    
     case 1:  // Matrix
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".val");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(outputNames.elementAt(i)+".rows");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(outputNames.elementAt(i)+".cols");
            ((JLabel)DescriptionVector.elementAt(e+3)).setText(outputNames.elementAt(i)+".leading");
            e += 4;
            break;

     case 6 : // String
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".val");
            e++;
            break;

     case 9:  // SparseMatrix
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".val");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(outputNames.elementAt(i)+".rows");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(outputNames.elementAt(i)+".cols");
            ((JLabel)DescriptionVector.elementAt(e+3)).setText(outputNames.elementAt(i)+".nzeros");
            ((JLabel)DescriptionVector.elementAt(e+4)).setText(outputNames.elementAt(i)+".col_index");
            ((JLabel)DescriptionVector.elementAt(e+5)).setText(outputNames.elementAt(i)+".row_ptr");
            e += 6;
            break;

     case 5:  //  File
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".val");
            e++;
            break;

     case 4: // UPF
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".language");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(outputNames.elementAt(i)+".filename");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(outputNames.elementAt(i)+".functionname");
             e += 3;
            break;
     case 8: //String List
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".stringcount");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(outputNames.elementAt(i)+".stringnames");
             e += 2;
             break;

     case  7: // PackedFiles
            ((JLabel)DescriptionVector.elementAt(e)).setText(outputNames.elementAt(i)+".filecount");
            ((JLabel)DescriptionVector.elementAt(e+1)).setText(outputNames.elementAt(i)+".filenames");
            ((JLabel)DescriptionVector.elementAt(e+2)).setText(outputNames.elementAt(i)+".defaultprefix");
              e += 3;
           break;


   }  // end of switch
 }    // end of for  TotalOutputs


}// end of setDescription()

public java.util.Vector getDescription()
{
 return DescriptionVector;
}

public java.util.Vector getInputNames()
 {
  return inputNames;
 }
public java.util.Vector getOutputNames()
 {
  return outputNames;
 }
int getSequenceSize()
  {
   int Objecttype;
   int e = 0; 
    for(int i = 0;i<TotalInputs;i++)
      {
        Objecttype = ip.getObjectType(i); 
       
         if(Objecttype == 3)  // scalar
          e++; 
         else
         if(Objecttype == 2) // Vector
           e += 2;
         else
         if(Objecttype == 1)  // Matrix
           e += 4;
         else
         if(Objecttype == 6) // String
           e++;
         else
         if(Objecttype == 9) // SparseMatrix
           e += 6;
         else
         if(Objecttype == 5) //  File
           e++;
         else
         if(Objecttype == 4) // UPF
           e += 3;
         else
         if(Objecttype == 8) //String List
           e += 2;
         else
         if(Objecttype == 7) // PackedFiles
           e += 3;
 
      }
 
   for(int i = 0;i<TotalOutputs;i++)
      {
         Objecttype = op.getObjectType(i);

         if(Objecttype == 3)  // scalar
           e++;
         else
         if(Objecttype == 2) // Vector
           e += 2;
         else
         if(Objecttype == 1)  // Matrix
           e += 4;
         else
         if(Objecttype == 6) // String
           e++;
         else
         if(Objecttype == 9) // SparseMatrix
           e += 6;
         else
         if(Objecttype == 5) //  File
           e++;
         else
         if(Objecttype == 4) // UPF
           e += 3;
         else
         if(Objecttype == 8) //String List
           e += 2;
         else
         if(Objecttype == 7) // PackedFiles
           e += 3;

      }
  return e;

   }  // end of getSequenceSize() 


IOSequence getCallSequence()
 {
  IOSequence cs = new IOSequence(SequenceSize);
  setSelectionArray();  
  try{
       for(int i=0;i<SequenceSize;i++)
        { cs.setElementAt(SelectionArray[i],i);
        }
     }
   catch (ArrayIndexOutOfBoundsException ae)
    {
     System.out.println("ArrayIndexOutOfBoundsException has occured\n");
    }

    return cs;
  }

 void setCallSequence(IOSequence cs)
 {

 try{
    for(int i = 0;i<cs.getSize();i++)
    {
    if(cs.getElementAt(i) != -1)
      ((JComboBox)SequenceCBox.elementAt(i)).setSelectedIndex(cs.getElementAt(i) -1);
   else
      ((JComboBox)SequenceCBox.elementAt(i)).setSelectedIndex(cs.getElementAt(i) +1);
   }  
  }
 catch(ArrayIndexOutOfBoundsException ae)
  {
  System.out.println("ArrayIndexOutOfBoundsException Has Occured in SetCallSequence\n");
  
  }
 }

 // n is the no. in the Selection Range  from 1 to SequenceSize
 // returns -1 if its equal to some previously selected value

  int getSelection(int n)
  {
   int Index = 0;
   Index = Integer.valueOf((String)(((JComboBox)SequenceCBox.elementAt(n)).getSelectedItem())).intValue();
   return Index;


  }

  void setSelectionArray()
  {

   for (int i =0;i<SequenceSize;i++)
    SelectionArray[i] = Integer.valueOf((String)(((JComboBox)SequenceCBox.elementAt(i)).getSelectedItem())).intValue();  

   for(int i=0;i<SequenceSize;i++)
    for(int j= i+1;j<SequenceSize;j++)
     if(SelectionArray[j] == SelectionArray[i])
       SelectionArray[j] = -1;

  }


 Arguments getArguments() 
 {
  Arguments a = new Arguments(SequenceSize);
  int argIndex = 0;
  
   for(int  i =0;i<ip.getInputNumbers();i++)
   {
    Objects obj = ip.getInputObject(i);
    for(int j =0;j<obj.getCallObj().getArgCount();j++)
    {
     a.setUserArg(obj.getName()+"."+obj.getCallObj().getArg(j),argIndex);
     //System.out.println(a.getUserArg(argIndex));
     a.setNetsolveArgs(obj.getCallObj().getMnemonic(j)+"I"+i,argIndex);
     a.setArgTypes(obj.getCallObj().getType(j),argIndex);
     argIndex++;
    }
   }

   for(int  i =0;i<op.getOutputNumbers();i++)
   {
    Objects obj = op.getOutputObject(i);
    for(int j =0;j<obj.getCallObj().getArgCount();j++)
    {
     a.setUserArg(obj.getName()+"."+obj.getCallObj().getArg(j),argIndex);
     a.setNetsolveArgs(obj.getCallObj().getMnemonic(j)+"O"+i,argIndex);
     a.setArgTypes(obj.getCallObj().getType(j),argIndex);
     argIndex++;
    }
   }

   return a;
  }


public void actionPerformed (ActionEvent ae)
{
 StringBuffer sb = new StringBuffer("\t\tCalling NetSolve from C & Fortran\n");
 sb.append("\t\tBlocking call for problem " + problemName);
 sb.append("\n\nC call : status = netsl('" + problemName + "()' " ); 
 int index = 0;

 for(int i = 0;i<SequenceSize;i++)
  {
   index = ((JComboBox)SequenceCBox.elementAt(i)).getSelectedIndex();
   sb.append(", "+((JLabel)DescriptionVector.elementAt(index)).getText()); 
   }
  sb.append(")");
  sb.append("\n\nFortran Call : FNETSL('" + problemName.toUpperCase()+ "()', STATUS " ); 
 for(int i = 0;i<SequenceSize;i++)
   {
   index = ((JComboBox)SequenceCBox.elementAt(i)).getSelectedIndex();
   sb.append(", "+((JLabel)DescriptionVector.elementAt(index)).getText().toUpperCase()); 
   }
 sb.append(")");


  StatusArea.setText(sb.toString()); 
 }


}
