 
/* This class is the Tabbed panel added to the XmlFrame 
 * Displays different panels as the user clicks on 
 * different tabs in the Tabbed panel
 */


import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
//import com.util.myjava.*;


public class ButtonPanel extends JTabbedPane
{
 
  DescriptionPanel dp;
  InputPanel ip;
  OutputPanel op;
  FileDetailsPanel fdetp;
  DetailsPanel detp;
  CodePanel cp;
  MCallingSequencePanel mcp;
  //CFCallingSequencePanel cfp;
  CFCSPanel cfp;
  ProblemDescription pd;
  StringBuffer ToolTipDT;   // ToolTip Text for Description Tab
  StringBuffer ToolTipIT; // ToolTip Text for Input Tab
  StringBuffer ToolTipOT; // ToolTip Text for Output Tab
  StringBuffer ToolTipDetT; // ToolTip Text for Detail Tab
  StringBuffer ToolTipCT; // ToolTip Text for Code Tab
  StringBuffer ToolTipMT; // ToolTip Text for Matlab Tab
  StringBuffer ToolTipCFT; // ToolTip Text for CFortran Tab
  MovingCanvas mc; 

 ButtonPanel(MovingCanvas mc)
 {
   final MovingCanvas fmc = mc;
   this.mc = fmc;
 
   dp = new DescriptionPanel();
   ip = new InputPanel(dp);
   op = new OutputPanel(dp);
   fdetp = new FileDetailsPanel();
   detp = new DetailsPanel();
   mcp = new MCallingSequencePanel(ip, op);
   cfp = new CFCSPanel(ip,op);
   cp = new CodePanel(cfp);
  
   ToolTipDT = new StringBuffer("This is Description Tab");
 
   addTab("Description",null,dp,ToolTipDT.toString());
   addTab("Input",null,ip,"This is Input Tab");
   addTab("Output",null,op,"This is Output Tab"); 
   addTab("File Details",null,fdetp,"This is File Details Tab"); 
   addTab("Details",null,detp,"This is Details Tab"); 
   addTab("Code",null,cp,"This is Code Tab"); 
   addTab("Matlab Calling Sequence",null,mcp,"This is Matlab Calling Sequence Tab"); 
   addTab("CFortran Calling Sequence",null,cfp,"This is CFortran Calling Sequence Tab"); 


 java.awt.Color Green = new java.awt.Color(100,255,100);
   for(int i = 0;i<8;i++)         
    this.setBackgroundAt(i,Green);  // when logged for first time everything is complete

      ip.UpdatePanel();
      op.UpdatePanel(); 
      mcp.UpdatePanel(); 
      cfp.UpdatePanel();
      cp.UpdatePanel();

// Anonymous inner class is used here

   addChangeListener(new ChangeListener()
   {
    // gets called when some tab is pressed thus update all the panels
     public void stateChanged(ChangeEvent ce) 
     {
      ip.UpdatePanel();
      op.UpdatePanel(); 
      mcp.UpdatePanel(); 
      cfp.UpdatePanel();
      cp.UpdatePanel();
      if(allComplete())  // set color of tabs to indicate comleteness of  panel
     {fmc.setVisible(false); fmc.delMsgs();
      fmc.stop();}

     }
   });
  
 }// end of ButtonPanel() constructor

  void updateAll()
 {
      ip.UpdatePanel();
      op.UpdatePanel(); 
      mcp.UpdatePanel(); 
      cfp.UpdatePanel();
      cp.UpdatePanel();
  } 


  boolean allComplete()
  {
   boolean Complete = true;
   boolean AllComplete = true;

   mc.delMsgs();  // delete all messages before checking panels
   mc.setVisible(false);

 
   java.awt.Color Red = new java.awt.Color(255,100,100);
   java.awt.Color Blue = new java.awt.Color(100,100,255);
   java.awt.Color Green = new java.awt.Color(100,255,100);

   Complete = checkDP();   // Description Panel
   if(Complete)
    this.setBackgroundAt(0,Green);
   else
    {this.setBackgroundAt(0,Red);
    AllComplete = false;}
       
   Complete = checkIP();  // Input Panel
   if(Complete)
    this.setBackgroundAt(1,Green);
   else
    {this.setBackgroundAt(1,Red);
    AllComplete = false;}
     

   Complete = checkOP();  // Output Panel
   if(Complete)
    this.setBackgroundAt(2,Green);
   else
    {this.setBackgroundAt(2,Red);
    AllComplete = false;}


    Complete = checkFdetP(); // file Details Panel
   if(Complete)
    this.setBackgroundAt(3,Green);
   else
    {this.setBackgroundAt(3,Red);
    AllComplete = false;}
 
     Complete = checkDetP(); // Details Panel
   if(Complete)
    this.setBackgroundAt(4,Green);
   else
    {this.setBackgroundAt(4,Red);
    AllComplete = false;}


   Complete = checkCP();  // Code Panel
   if(Complete)
    this.setBackgroundAt(5,Green);
   else
    {this.setBackgroundAt(5,Red);
    AllComplete = false;}

   Complete = checkMCSP(); // Matlab Calling Sequence Panel
   if(Complete)
    this.setBackgroundAt(6,Green);
   else
    {this.setBackgroundAt(6,Red);
    AllComplete = false;}


   Complete = checkCFCP(); // C Fortran Calling Sequence Panel
   if(Complete)
    this.setBackgroundAt(7,Green);
   else
    {this.setBackgroundAt(7,Red);
    AllComplete = false;}
  
   return AllComplete;
 
    } 

 boolean checkDP()
 {
  int ind = getSelectedIndex();
  boolean Complete = true;

  if(dp.getFunction_name().equals(""))
    {
      Complete = false; 
       
      mc.addMsg(" Error: Check The Problem Name Field in Description Panel");
     if(ind == 0)   // display it only if desc. panel
       mc.setVisible(true);
      mc.start();
    }

  if(dp.getInputNumbers() == 0 )
   { Complete = false; 
     mc.addMsg(" Error: Check the Input Field in Description Panel");
    if(ind == 0 || ind == 1) // t only if desc. panel & input Panel
     mc.setVisible(true);
     mc.start();
   }
       
  if(dp.getOutputNumbers() == 0)
   { Complete = false; 
     mc.addMsg(" Error: Check the Output Field in Description Panel");
    if(ind == 0 || ind == 2) // t only if desc. panel & output Panel
     mc.setVisible(true);
     mc.start();
    }

   return Complete;

 } 
 boolean checkIP()
 {
  int ind = getSelectedIndex();

  boolean Complete = true;
 
  int n = ip.getInputNumbers();
  int DataType;
  int ObjectType;
  if(n == 0)
   Complete = false; 
  
  for(int i = 0;i< n;i++)
   {
    DataType = ip.getDataType(i) ;
    ObjectType = ip.getObjectType(i);

    if(DataType == 0 && (ObjectType == 3 || ObjectType == 2 || ObjectType == 1 || ObjectType == 9))
     { Complete = false; 
       mc.addMsg(" Error: Input "+ (i+1)+" Type MisMatch in InputPanel ");
    if(ind == 1) // t only if input Panel
       mc.setVisible(true);
       mc.start();
     }

    if(DataType > 0 && ObjectType < 9 && ObjectType > 3)
     {Complete = false; 
      mc.addMsg(" Error: Input "+ (i+1)+" Type MisMatch in InputPanel ");
    if(ind == 1) // t only if input Panel
      mc.setVisible(true);
      mc.start();
      }
    } 
    return Complete;
 }  // end of checkIP
 

 boolean checkOP()
 {
 int ind = getSelectedIndex();

 boolean Complete = true;
 
  int n = op.getOutputNumbers();
  int DataType;
  int ObjectType;
  if(n == 0)
  Complete = false; 
    
  for(int i = 0;i< n;i++)
  {
   DataType = op.getDataType(i) ;
   ObjectType = op.getObjectType(i);

  if(DataType == 0 && (ObjectType == 3 || ObjectType == 2 || ObjectType == 1 || ObjectType == 9))
   { Complete = false; 
     mc.addMsg(" Error: Output "+(i+1)+" Type MisMatch in OutputPanel ");
    if(ind == 2) // t only if output Panel
     mc.setVisible(true);
     mc.start();
   }
 if(DataType > 0 && ObjectType < 9 && ObjectType > 3)
   { Complete = false; 
     mc.addMsg(" Error: Output "+(i+1)+" Type MisMatch in OutputPanel ");
    if(ind == 2) // t only if output Panel
     mc.setVisible(true);
     mc.start();
    }
   }
   return Complete;
 } // end of checkOP 


 boolean checkDetP()
 {
 int ind = getSelectedIndex();

  boolean Complete = true;

// 0 if the user enters non integer value in the textfield
  if(detp.getA() == 0 )
  {Complete = false; 
   mc.addMsg(" Error:  Please Check Complexity a field in Details Panel ");
  if(ind == 4) // t only if details Panel
   mc.setVisible(true);
   mc.start();
   }
   if(detp.getB() == 0 )
   {Complete = false; 
   mc.addMsg(" Error:  Please Check Complexity b field in Details Panel ");
  if(ind == 4) // t only if details Panel
   mc.setVisible(true);
   mc.start();
   }
 int one = detp.getmmObj1();
 int two = detp.getmmObj2();

  if(one == 0 )
   {Complete = false;
   mc.addMsg(" Error:  Please Check MatlabMerge Object 1 field in Details Panel ");
  if(ind == 4) // t only if details Panel
   mc.setVisible(true);
   mc.start();
   }
  
  if(two == 0 )
   {Complete = false;
   mc.addMsg(" Error:  Please Check MatlabMerge Object 2 field in Details Panel ");
  if(ind == 4) // t only if details Panel
   mc.setVisible(true);
   mc.start();
   } 

  // -1 if user is not setting matlab merge 
  // if not -1 and they are greater than outpur size 
  // or not consecutive then flag error
if(one != -1 && two != -1)
{  
 int size = op.getOutputNumbers();
 if((one >= size || two >= size) || (one != two -1))
   {Complete = false;
   mc.addMsg(" Error:  Please Check MatlabMerge Objects field in Details Panel, There are not many outputs or they are not consecutive  ");
  if(ind == 4) // t only if details Panel
   mc.setVisible(true);
   mc.start();
   }
}

   if(detp.getPathName().equals(""))
   {Complete = false; 
   mc.addMsg(" Error:  Please Check Path Name field in Details Panel ");
  if(ind == 4) // t only if details Panel
   mc.setVisible(true);
   mc.start();
   }
 
  return Complete; 
 } 

boolean checkFdetP()
 {

  boolean Complete = true;
  return Complete; 
 }

 boolean checkCP()
 {
  return true;
 } 
 boolean checkMCSP()
 {
  if(mcp.getInputObjectSequence().getSize() == 0)
   return false;
  else
    if(mcp.getOutputObjectSequence().getSize() == 0)
      return false;
    else
      return true;
 } 
 boolean checkCFCP()
 {
  return true;
 } 


 void fillGUIfield(ProblemDescription pd)
 {
 // DescriptionPanel is filled first 
 dp.setFunction_name(pd.getName());  // problem name Perfect
 dp.setDescription(pd.getDescription());  // perfect
 dp.setInputTextField(pd); // Perfect 
 dp.setOutputTextField(pd); // Perfect

 detp.setPathName(pd.getPath()); // Perfect
 detp.setLanguage(pd.getLanguage()); // Perfect
 detp.setMajor(pd.getMajor()); // Perfect
 detp.setMatlabMerge(pd.getMatlabMerge()); // Perfect
 
// needs to pass pd as other things required from pd to change the mnemonics to user friedly representation
 cp.setCode(pd); // Perfect
 detp.setComplexity(pd.getComplexity()); // Perfect
 detp.setCustomName(pd.getCustomName()); // Perfect

 detp.setFunctionName(pd.getFunctions());  // returns an enumeration
 fdetp.setIncludeFileName(pd.getIncludes());  // returns an enumeration 
 fdetp.setIncludeDirName(pd.getDashIs());  // returns an enumeration 
 
 fdetp.setLibraryFileName(pd.getLibs());  // returns an enumeration 
 fdetp.setLibraryDirName(pd.getLibdirs());  // returns an enumeration 




// Update The panels that depends on No. of Inputs and Outputs
 ip.UpdatePanel();
 op.UpdatePanel();
 mcp.UpdatePanel();
 cfp.UpdatePanel();
 
 mcp.setInputObjectSequence(pd.getInputObjectSequence());

 for(int i = 0;i<pd.numInputObjects();i++)
  ip.setInputObject(pd.getInputObject(i),i);


 mcp.setOutputObjectSequence(pd.getOutputObjectSequence());
 
 for(int i = 0;i<pd.numOutputObjects();i++)
  op.setOutputObject(pd.getOutputObject(i),i);
 


 cfp.setCallSequence(pd.getCallSequence());





// carry on seeing fillproblemdescrition() 

 }


 ProblemDescription fillProblemDescription()
  {
   pd = new ProblemDescription();
   pd.setDescription(dp.getDescription());
   pd.setName(dp.getFunction_name()); // problem name
   pd.setPath(detp.getPathName());
   pd.setLanguage(detp.getLanguage());
   pd.setMajor(detp.getMajor()); 
   pd.setMatlabMerge(detp.getMatlabMerge()); 
   pd.setCode(cp.getCode());
   pd.setComplexity(detp.getComplexity());  // if 0 , 0 then invalid
   pd.setCustomName(detp.getCustomName());
 
    pd.setInputObjectSequence(mcp.getInputObjectSequence());

   for(int i =0;i<ip.getInputNumbers();i++)
    pd.addInputObject(ip.getInputObject(i));
  
    pd.setOutputObjectSequence(mcp.getOutputObjectSequence());

   for(int i =0;i<op.getOutputNumbers();i++)
    pd.addOutputObject(op.getOutputObject(i));

    pd.setArgCount(cfp.getSequenceSize());
  
    pd.setCallSequence(cfp.getCallSequence());
    pd.setArguments(cfp.getArguments());   


   for(int i =0;i<detp.getFunctionNumbers();i++)
    pd.addFunction(detp.getFunctionName(i));
   
   for(int i =0;i<fdetp.getIncludeFileNumbers();i++)
    pd.addInclude(fdetp.getIncludeFileName(i));

   for(int i =0;i<fdetp.getLibraryFileNumbers();i++)
    pd.addLib(fdetp.getLibraryFileName(i));

   for(int i =0;i<fdetp.getIncludeDirNumbers();i++)
    pd.addDashI(fdetp.getIncludeDirName(i));
  
   for(int i =0;i<fdetp.getLibraryDirNumbers();i++)
    pd.addLibdir(fdetp.getLibraryDirName(i));


  return pd;   // ProblemDescription Object is filled with info

  }



}// end of Class ButtonPanel

