/*****************************************************************/
/*      mxwaitequest.c                                           */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"
#include <signal.h>

/*
 *  wait for a request
 */
void mxWaitRequest(int nlhs,mxArray *plhs[],int nrhs,mxArray **prhs)
{
  int request_id;
  NS_RequestDesc *rd;
  int *input_allocated;
  int i,status;
  int elapsed;


  if (nrhs != 1)
  {
    mexPrintf("Usage: [....] = netsolve_nb('wait',<request_id>)\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    ns_errno = NetSolveBadValues;
    return;
  }

  request_id = (int)(mxGetPr(prhs[0])[0]);
  if ((request_id < 0)||(request_id > NB_MAX_REQUESTS))
  {
    mexPrintf("Invalid request ID\n");
    ns_errno = NetSolveInvalidRequestID;
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    return;
  }

  /* Find the request_descriptor */
  rd = requests[request_id];
  input_allocated = input_allocateds[request_id];

  if (rd == NULL)
  {
    ns_errno = NetSolveInvalidRequestID;
    mexPrintf("Invalid request ID\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    return;
  }

  /* check the output */
  if ((rd->pd->nb_output_objects < nlhs)||
      (nlhs < rd->pd->nb_output_objects - rd->pd->nb_matlab_merge))
  {
    ns_errno = NetSolveBadProblemSpecification;
    mexPrintf("'%s' requires %d objects in output and %d of those can be merged\n",
              rd->pd->nickname,rd->pd->nb_input_objects,rd->pd->nb_matlab_merge);
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    return;
  }

  status = netsolveWaitRequest(NS_NOASSIGNMENT, &rd,&elapsed);

  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    free(input_allocated);
    input_allocateds[request_id] = NULL;
    freeProblemDesc(rd->pd);
    freeRequestDesc(rd);
    requests[request_id] = NULL;
    return;
  }

  /* Take care of the output */
  status = mxFillInOutputObjects(rd->pd,nlhs,plhs);
  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    requests[request_id] = NULL;
    for (i=0;i<rd->pd->nb_input_objects;i++)
      if (input_allocated[i])
    freeObjectData(rd->pd->input_objects[i]);
    free(input_allocated);
    input_allocateds[request_id] = NULL;
    freeProblemDesc(rd->pd);
    freeRequestDesc(rd);
    return;
  }

  for (i=0;i<rd->pd->nb_input_objects;i++)
    if (input_allocated[i])
      freeObjectData(rd->pd->input_objects[i]);
  free(input_allocated);
  input_allocateds[request_id] = NULL;
  freeProblemDesc(rd->pd);
  freeRequestDesc(rd);
  requests[request_id] = NULL;
  ns_errno = NetSolveOK;
  return;
}
