/*****************************************************************/
/*      mxsendnonblockinrequest.c                                */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"
#include <signal.h>

/*
 * Send a non-blocking requests to NetSolve and record
 * it in the 'request' global array
 */
void mxSendRequest(int nlhs,mxArray *plhs[],int nrhs,mxArray **prhs)
{
  NS_ProblemDesc *pd;
  int request_id;
  char buffer[256];
  int status,i;
  int *input_allocated=NULL;
  NS_IPaddr_type server_IPaddr;
  char *server_hostname;
  int predicted_time;
  int start_time;
  NS_Communicator *comm;
  NS_RequestDesc *rd;
  char *agent_name;

  /* Error */
  if (!mxIsChar(prhs[0]))
  {
    mexPrintf("Usage: [request_id] = netsolve_nb('send','problem name',...)\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    ns_errno = NetSolveBadValues;
    return;
  }

  /* Error */
  if (nlhs != 1)
  {
    mexPrintf("Usage: [request_id] = netsolve_nb('send','problem name',...)\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    ns_errno = NetSolveBadValues;
    return;
  }


  mxGetString(prhs[0],buffer,256);

  /* Get the problem descriptor */
  agent_name = getNetSolveAgent();
  if (agent_name == NULL)
  {
    ns_errno = NetSolveSetNetSolveAgent;
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    return;
  }
  status = netsolveInfo(buffer,&pd);
  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    return;
  }

  /* Check the input */
  status = mxInitializeInputObjects(pd,nrhs-1,
               (mxArray**)(&(prhs[1])),&input_allocated);
  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    if (input_allocated != NULL)
    {
      for (i=0;i<pd->nb_input_objects;i++)
        if (input_allocated[i])
          freeObjectData(pd->input_objects[i]);
      free(input_allocated);
    }
    freeProblemDesc(pd);
    return;
  }

  /* Initialize the output */
  status = mxInitializeOutputObjects(pd);
  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    if (input_allocated != NULL)
    {
      for (i=0;i<pd->nb_input_objects;i++)
        if (input_allocated[i])
          freeObjectData(pd->input_objects[i]);
      free(input_allocated);
    }
    freeProblemDesc(pd);
    return;
  }

  /* submit the request */

  rd = netsolveSendRequest(NS_NOASSIGNMENT, NULL, pd,pd->input_objects,
                 pd->output_objects);
  if (rd == NULL)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    if (input_allocated != NULL)
    {
      for (i=0;i<pd->nb_input_objects;i++)
        if (input_allocated[i])
          freeObjectData(pd->input_objects[i]);
      free(input_allocated);
    }
    freeProblemDesc(pd);
    return;
  }

  fprintf(STDERR "rd->request_id = %d\n",rd->request_id);

  /* Make that memory persistent */
  mxMakeRequestDescPersistent(rd,input_allocated);
  mexMakeMemoryPersistent(input_allocated);

  /* find a slot in the global array */
  request_id = 0;
  while(requests[request_id] != NULL)
    request_id++;

  requests[request_id] = rd;
  input_allocateds[request_id] = input_allocated;

  plhs[0] = mxCreateDoubleMatrix(1,1,mxREAL);
  mxGetPr(plhs[0])[0] = (double)request_id;
  ns_errno = NetSolveOK;
  return;
}
