/*****************************************************************/
/*      mxrequestdesc.c                                          */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"
#include <sys/types.h>
#include <sys/stat.h>

/*
 * mxMakeRequestDescPersistent()
 */
void mxMakeRequestDescPersistent(NS_RequestDesc *rd,int *input_allocated)
{
  int i;

  mexMakeMemoryPersistent(rd->hostname);
  mexMakeProblemDescPersistent(rd->pd,input_allocated);
  mexMakeMemoryPersistent(rd);
  ns_errno = NetSolveOK;
  return;
}

/*
 * mexMakeProblemDescPersistent()
 */
void mexMakeProblemDescPersistent(NS_ProblemDesc *pd,int *input_allocated)
{
  int i;

  if (pd == NULL)
    return;
  mexMakeMemoryPersistent(pd);
  mexMakeMemoryPersistent(pd->name);
  mexMakeMemoryPersistent(pd->nickname);
  mexMakeMemoryPersistent(pd->description);
  mexMakeMemoryPersistent(pd->file);
  mexMakeMemoryPersistent(pd->customized);
  mexMakeMemoryPersistent(pd->matlab_merge);
  mexMakeMemoryPersistent(pd->complexity);
  mexMakeMemoryPersistent(pd->input_objects);
  mexMakeMemoryPersistent(pd->output_objects);

  for (i=0;i<pd->nb_input_objects;i++)
    mexMakeObjectPersistent(pd->input_objects[i],input_allocated[i]);
  for (i=0;i<pd->nb_output_objects;i++)
    mexMakeMemoryPersistent(pd->output_objects[i]);

  mexMakeCallingSequencePersistent(pd->calling_sequence);
  ns_errno = NetSolveOK;
  return;
}

/*
 * mexMakeCallingSequencePersistent()
 */
void mexMakeCallingSequencePersistent(NS_CallingSequence *cs)
{
  int i;
  if (cs == NULL)
    return;
  for (i=0;i<cs->nb_args;i++)
    mexMakeMemoryPersistent(cs->arg_to_mnemonic[i]);
  mexMakeMemoryPersistent(cs->arg_to_mnemonic);
  for (i=0;i<cs->nb_constants;i++)
  {
    mexMakeMemoryPersistent(cs->constants[i].mnemonic);
    mexMakeMemoryPersistent(cs->constants[i].value);
  }
  mexMakeMemoryPersistent(cs->constants);
  for (i=0;i<cs->nb_formulae;i++)
  {
    mexMakeMemoryPersistent(cs->formulae[i].mnemonic);
    mexMakeMemoryPersistent(cs->formulae[i].expression);
  }
  mexMakeMemoryPersistent(cs->formulae);
  mexMakeMemoryPersistent(cs);
  ns_errno = NetSolveOK;
  return;
}

/*
 *  mexMakeObjectPersistent()
 */
void mexMakeObjectPersistent(NS_Object *obj,int data)
{
  int i;
  mexMakeMemoryPersistent(obj);

  switch(obj->object_type)
  {
    case NETSOLVE_MATRIX:
      if (data)
        mexMakeMemoryPersistent(obj->attributes.matrix_attributes.ptr);
      break;
    case NETSOLVE_SPARSEMATRIX:
      if (data)
        mexMakeMemoryPersistent(obj->attributes.sparsematrix_attributes.ptr);
      break;
    case NETSOLVE_VECTOR:
      if (data)
        mexMakeMemoryPersistent(obj->attributes.vector_attributes.ptr);
      break;
    case NETSOLVE_SCALAR:
      if (data)
        mexMakeMemoryPersistent(obj->attributes.scalar_attributes.ptr);
      break;
    case NETSOLVE_FILE:
        mexMakeMemoryPersistent(obj->attributes.file_attributes.filename);
      break;
    case NETSOLVE_PACKEDFILES:
        mexMakeMemoryPersistent(obj->attributes.packedfiles_attributes.filenames);
        for (i=0;i<obj->attributes.packedfiles_attributes.m;i++)
          mexMakeMemoryPersistent(
                   obj->attributes.packedfiles_attributes.filenames[i]);
      break;
    case NETSOLVE_UPF:
        mexMakeMemoryPersistent(obj->attributes.upf_attributes.filename);
        mexMakeMemoryPersistent(obj->attributes.upf_attributes.funcname);
      break;
    case NETSOLVE_STRING:
        if (data)
          mexMakeMemoryPersistent(obj->attributes.string_attributes.ptr);
      break;
  }
  ns_errno = NetSolveOK;
  return;
}

