/*****************************************************************/
/*      mxnetsolve_nb.c                                          */
/*      Henri Casanova          				 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"

/*
 * Non-Blocking call to NetSolve from Matlab
 */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  int i;
  char buffer[256];
  int cmd;

  my_major = COL_MAJOR;

#ifdef WIN32
  if (!WinSockInit())
  {
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    mxSetNSErrno(NetSolveNetworkError);
    return;
  }
#endif

  proxy_port = mxGetProxyPort();
  proxy_port = mxGetProxyPort();
  if (proxy_port == -1) {
    char *agent_name;

    agent_name = getNetSolveAgent();
    if (agent_name == NULL) {
      ns_errno = NetSolveSetNetSolveAgent;
      mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
      mxSetNSErrno(ns_errno);
      for (i=0;i<nlhs;i++)
        plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
      return;
    }

    /* Start the proxy !! */
    if (startProxy("NetSolve",agent_name,&proxy_pid,&proxy_port) == -1)     
    {
      mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
      mxSetNSErrno(ns_errno);
      for (i=0;i<nlhs;i++)
        plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
      return;
    }

    mxSetProxyPort(proxy_port);
  }

  if (nrhs == 0)
  {
    mexPrintf("Arguments required\n");
    mexPrintf("Should be : '[r] = netsolve_nb(operation,");
    mexPrintf("problem name, arguments)' where\n");
    mexPrintf("  - operation can be 'send', 'wait', 'probe' or 'status'\n");
    mexPrintf("  - problem name in a string (e.g. 'eig')\n");
    mexPrintf("  - arguments description is available by typing :\n");
    mexPrintf("              netsolve(problem name) (e.g. netsolve('eig'))\n");
    mexPrintf("  - netsolve_nb('status') gives you information ");
    mexPrintf("on the pending requests\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    ns_errno = NetSolveBadValues;
    mxSetNSErrno(ns_errno);
    return;
  }

  if (!mxIsChar(prhs[0]))
  {
    mexPrintf("Invalid first argument : should be a string\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    ns_errno = NetSolveBadValues;
    mxSetNSErrno(ns_errno);
    return;
  }
  mxGetString(prhs[0],buffer,256);

  cmd = mxParseNbCommand(buffer);

  switch(cmd)
  {
    case ERROR_CMD:
      mexPrintf(
         "Invalid first argument,should be 'send', 'wait', 'probe' or 'status'\n");
      for (i=0;i<nlhs;i++)
        plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
      ns_errno = NetSolveBadValues;
      mxSetNSErrno(ns_errno);
      return;
      break;
    case SEND_CMD:
      mxSendRequest(nlhs,plhs,nrhs-1,(mxArray**)(&(prhs[1])));
      break;
    case WAIT_CMD:
      mxWaitRequest(nlhs,plhs,nrhs-1,(mxArray**)(&(prhs[1])));  
      break;
    case PROBE_CMD:
      mxProbeRequest(nlhs,plhs,nrhs-1,(mxArray**)(&(prhs[1])));
      break;
    case STATUS_CMD:
      mxDisplayRequestStatus();
      for (i=0;i<nlhs;i++)
        plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
      break;
  }
  mxSetNSErrno(ns_errno);
  return;
}

/*
 * mxParseNbCommand()
 */
int mxParseNbCommand(char *buf)
{
  netsolveCaps(buf);

  if ((strcmp(buf,"S") == 0)   ||
      (strcmp(buf,"SE") == 0)  ||
      (strcmp(buf,"SEN") == 0) ||
      (strcmp(buf,"SEND") == 0))
    return SEND_CMD;

  if ((strcmp(buf,"W") == 0)   ||
      (strcmp(buf,"WA") == 0)  ||
      (strcmp(buf,"WAI") == 0) ||
      (strcmp(buf,"WAIT") == 0))
    return WAIT_CMD;

  if ((strcmp(buf,"P") == 0)    ||
      (strcmp(buf,"PR") == 0)   ||
      (strcmp(buf,"PRO") == 0)  ||
      (strcmp(buf,"PROB") == 0) ||
      (strcmp(buf,"PROBE") == 0))
    return PROBE_CMD;

  if ((strcmp(buf,"ST") == 0)   ||
      (strcmp(buf,"STA") == 0)  ||
      (strcmp(buf,"STAT") == 0) ||
      (strcmp(buf,"STATU") == 0) ||
      (strcmp(buf,"STATUS") == 0))
    return STATUS_CMD;

  return ERROR_CMD;

}
