/*****************************************************************/
/*      mxnetsolve_init.c                                        */
/*      Henri Casanova          				 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"

/*
 * initialise NetSolve
 */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  char *agent_name;
  int i;

  if ((nlhs != 0)||(nrhs>1))
  {
    mexPrintf("Usage: netsolve_init[(agent name)]\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL); 
    return;
  }

  /* Set the agent_name */

  if (nrhs == 0)
  {
    agent_name = getNetSolveAgent();
    if (agent_name == NULL)
    {
      ns_errno = NetSolveSetNetSolveAgent;
      mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
      mxSetNSErrno(ns_errno);
      return;
    } 
  }
  else
  {
    char buffer[256];
    
    mxGetString(prhs[0],buffer,256);
    agent_name = strdup(buffer);
  }
  
  /* Get the data format */
  my_data_format = getArch();
  if (my_data_format == -1)
  {
    ns_errno = NetSolveSetNetSolveArch;
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    mxSetNSErrno(ns_errno);
    return;
  }

  /* Start the proxy !! */
  if (startProxy("NetSolve",agent_name,&proxy_pid,&proxy_port) == -1)          
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    mxSetNSErrno(ns_errno);
    return;
  }
  mexPrintf("NetSolve initialized successfully\n");

  mxSetProxyPort(proxy_port);
  return;
}
