/*****************************************************************/
/*      mxinitializeoutputobjects.c                              */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"
#include <sys/types.h>
#include <sys/stat.h>

/*
 * Initialize the output objects
 *
 *  If it fails, then it's the caller responsibility to
 *  call free.
 */
int mxInitializeOutputObjects(NS_ProblemDesc *pd)
{
  int i,j;
  int object_type,data_type;

  for (i=0;i<pd->nb_output_objects;i++)
  {
    object_type = pd->output_objects[i]->object_type;
    data_type = pd->output_objects[i]->data_type;

    switch(object_type)
    {
      case NETSOLVE_MATRIX:
      {
        freeObject(pd->output_objects[i]);
        pd->output_objects[i] = createMatrixObject(
                data_type,
                NULL,-1,-1,-1,-1);
        break;
      }
      case NETSOLVE_SPARSEMATRIX:
      {
        freeObject(pd->output_objects[i]);
        pd->output_objects[i] = createSparseMatrixObject(
                data_type, NULL,-1,-1,-1,-1, NULL, NULL);
        break;
      }
      case NETSOLVE_VECTOR:
      {
        freeObject(pd->output_objects[i]);
        pd->output_objects[i] = createVectorObject(
                data_type,
                NULL,-1);
        break;
      }
      case NETSOLVE_SCALAR:
      {
        freeObject(pd->output_objects[i]);
        pd->output_objects[i] = createScalarObject(
                data_type,NULL);
        break;
      }
      case NETSOLVE_FILE:
      {
        char buffer[256];
        sprintf(buffer,"./%s-output%d-%d",pd->nickname,i,rand());
        freeObject(pd->output_objects[i]);
        pd->output_objects[i] = createFileObject(buffer);
        break;
      }
      case NETSOLVE_PACKEDFILES:
      {
        char buffer[256];
        sprintf(buffer,"./%s-output%d-%d",pd->nickname,i,rand());
        pd->output_objects[i] = createPackedFilesObject(buffer,NULL,-1);
        break;
      }

      case NETSOLVE_STRING:
      {
        freeObject(pd->output_objects[i]);
        pd->output_objects[i] = createStringObject(NULL);
        break;
      }
      default:
#ifdef VIEW
        mexPrintf("Unkonwn object type\n");
#endif
        ns_errno = NetSolveInternalError;
        return -1;
    }
  }
  ns_errno = NetSolveOK;
  return 1;
}
