/*****************************************************************/
/*      mxdisplaylistofserveragents.c                            */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"

/*
 * Displays the list of availble servers and agents
 */
void mxDisplayListOfServersAgents()
{
  NS_ServerDesc **server_list;
  NS_AgentDesc **agent_list;
  int nb_servers;
  int nb_agents;
  int i;

  mexPrintf("NetSolve - List of available agents -\n");
  nb_agents = getAllAgents(&agent_list);

  /* Error */
  if (nb_agents == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    return;
  }


  /* No agents */
  if (nb_agents == 0)
    mexPrintf("none\n\n");

  /* sorting the list */
  qsort(agent_list,nb_agents,sizeof(NS_AgentDesc *),agentOrder);

  /* Printing the list */
  for (i=0;i<nb_agents;i++)
  {
    mexPrintf("%s(%u.%u.%u.%u)\n",agent_list[i]->host_desc->hostname,
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),0), 
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),1), 
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),2), 
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),3));
  }

  for (i=0;i<nb_agents;i++)
    freeAgentDesc(agent_list[i]);
  free(agent_list);

  mexPrintf("NetSolve - List of available servers -\n");
  nb_servers = getAllServers(&server_list);

  /* Error */
  if (nb_servers == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    return;
  }


  /* No servers */
  if (nb_servers == 0)
    mexPrintf("none\n\n");

  /* sorting the list */
  qsort(server_list,nb_servers,sizeof(NS_ServerDesc *),serverOrder);

  /* Printing the list */
  for (i=0;i<nb_servers;i++)
  {
    mexPrintf("%s(%u.%u.%u.%u) (%d failures)\n",server_list[i]->host_desc->hostname,
                                  BYTE(&(server_list[i]->host_desc->IPaddr),0),
                                  BYTE(&(server_list[i]->host_desc->IPaddr),1),
                                  BYTE(&(server_list[i]->host_desc->IPaddr),2),
                                  BYTE(&(server_list[i]->host_desc->IPaddr),3),
                                  server_list[i]->nb_failures);
  }
  for (i=0;i<nb_servers;i++)
    freeServerDesc(server_list[i]);
  free(server_list);

  ns_errno = NetSolveOK;
  return;
}
