/*****************************************************************/
/*      mxdisplaylistofproblems.c                                */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"

/*
 * Displays the list of availble problems
 */
void mxDisplayListOfProblems()
{
  NS_ProblemDesc **problem_list;
  int nb_problems;
  int i;

  nb_problems = getAllProblems(&problem_list);

  /* Error */
  if (nb_problems == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    return;
  }

  mexPrintf("NetSolve - List of available problems -\n");

  /* No problems */
  if (nb_problems == 0)
  {
    mexPrintf("none\n\n");
    ns_errno = NetSolveOK;
    return;
  }

  /* sorting the list */
  qsort(problem_list,nb_problems,sizeof(NS_ProblemDesc *),problemOrder);

  /* Printing the list */
  for (i=0;i<nb_problems;i++)
    mexPrintf("%s\n",problem_list[i]->name);

  /* Freeing some memory */
  for (i=0;i<nb_problems;i++)
  {
    freeProblemDesc(problem_list[i]);
  }
  free(problem_list);
  
  /* Help */
  mexPrintf("-----------------------\n");
  mexPrintf("[ output args ] = netsolve(problem name, input args)\n");
  mexPrintf("-----------------------\n");
  mexPrintf("Information on a specific problem : netsolve(problem name)\n");
  mexPrintf("Information on the servers : netsolve('?')\n");
  mexPrintf("-----------------------\n");
  ns_errno = NetSolveOK;
  return;
}
