
BeginPackage["NetSolve`"]
NetSolve::usage = "usage: NetSolve[FuncName[arg1, ...]]    - blocking problem call
                          NetSolveNB[FUNCNAME[arg1, ...]] - nonblocking problem call
                          NetSolve[\\\"?problems\\\"]            - shows a list of available problems
                          NetSolve[\\\"?servers\\\"]             - shows a list of available servers
                          NetSolve[\\\"?FuncName[]\\\"]          - shows a problem description"
			  
Begin["`Private`"]

ClearAll["NetSolve*"];

(* User should set this manually to point NSMATH to your netsolve root directory *)

NSMATH = $HomeDirectory<>"/NetSolve";
  
(* User should set NSARCH as you configure, you can find your arch in conf/Makefile.inc *)
NSARCH = "i686_pc_linux_gnu";
       
NSMATHFILE = NSMATH <> "/bin/" <> NSARCH <> "/NS_math";
If[ ToString[FileType[NSMATHFILE]] != "File",
   ( Print[NSMATHFILE, " not found."];
      Print["Did you compile it for your platform successfully?"]),
   nsmathlink = Install[NSMATHFILE]
  ];

End[] 
EndPackage[]
