#include "mcelldriver.h"
#include "core.h"
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

/*
 * parseScriptFile()
 */
NS_MCellComputationDesc **parseScriptFile(char *script,int *nb_comps)
{
  NS_MCellComputationDesc **new=NULL;
  NS_MCellComputationDesc *newcomp;
  FILE *f;
  int nb = 0;
  int iterations;
  int i;
  char line[256];
  int linecount = 0;
  char *ptr1,*ptr2,*ptr3,*ptr4;
  int start,end;

  f = fopen(script,"r");
  if (f == NULL)
  {
    fprintf(stderr,"%s: file not found\n",script);
    return NULL;
  }
  while(fgets(line,256,f))
  {
    linecount++;
    if (line[0] == '#')
      continue;
    if (strncmp(line,"mcell ",6))
    {
      fprintf(stderr,"%s, %d: Syntax error\n",script,linecount);
      fclose(f);
      return NULL;
    }
    ptr1 = strtok(line," \t");
    ptr2 = strtok(NULL," \t");
    ptr3 = strtok(NULL," \t\n");
    ptr4 = strtok(NULL," \t\n");
    if ((ptr1 == NULL) || (ptr2 == NULL) || (ptr3 == NULL))
    {
      fprintf(stderr,"%s, %d: Syntax error\n",script,linecount);
      fclose(f);
      return NULL;
    }
    if (getRange(ptr3,&start,&end) == -1)
    {
      fprintf(stderr,"%s, %d: '%s' invalid seed or range specification\n",
                script,linecount,ptr3);
      fclose(f);
      return NULL;
    }
    if (ptr4 != NULL)
    {
      if (!isInteger(ptr4))
      {
        fprintf(stderr,"%s, %d: '%s' invalid iteration specification\n",
                script,linecount,ptr4);
        fclose(f);
        return NULL;
      }
      iterations = atoi(ptr4);
    }
    else
      iterations = -1;

    for (i=start;i<=end;i++)
    {
      newcomp = constructMCellComputationDesc(ptr2,i,iterations);      
      if (newcomp == NULL)
      {
        fclose(f);
        return NULL;
      }
      nb++;
      new = (NS_MCellComputationDesc**)myRealloc(new,
                  nb*sizeof(NS_MCellComputationDesc*));
      new[nb-1] = newcomp;
    }
  }  
  *nb_comps = nb;
  return new;
}

/*
 * getRange()
 */
int getRange(char *range,int *start, int *end)
{
  if (range[0] != '[') /* It has to be a number */
  {
    if (!isInteger(range))  /* isInteger is in the NetSolve library */
      return -1;
    *start = atoi(range);
    *end = atoi(range);
    return 1; 
  }
  if (sscanf(range,"[%d-%d]",start,end) != 2) 
    return -1;
  else
  {
    if (*start > *end)
      return -1;
    return 1;
  }
}





