/*
 * mcelldriver.c
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "mcelldriver.h"
#include "netsolve.h"
#include "general.h"

int main(int argc, char **argv)
{
  int i;
  int nb_comps;
  NS_MCellComputationDesc **comps;
  char ***I0;
  char ***I1;
  int *mI0;
  char ***I2;
  int *mI2;
  int **I3;
  int **I4;
  char **O0;
  char **O1;
  char **O2;
  int *status;
  char buffer[15];

  /* Parsing the command line */
  if (argc != 2)
  {
    fprintf(stderr,"Usage: %s <script file>\n",argv[0]);
    exit(-1);
  }
  
  /* Parsing the script to generate the descriptors */
  /* or get previously saved parsing information    */

  if (isOriginalScript(argv[1]))
  {
    comps = parseScriptFile(argv[1],&nb_comps);
    if (comps == NULL)
      exit(-1);
    saveParseFile(argv[1],nb_comps,comps);
  }
  else
  {
    comps = loadParseFile(argv[1],&nb_comps);
    if (comps == NULL)
      exit(-1);
  }

  /* Allocating memory for the farming data */
  I0 = (char ***)calloc(nb_comps,sizeof(char**));
  I1 = (char ***)calloc(nb_comps,sizeof(char**));
  mI0 = (int *)calloc(nb_comps,sizeof(int));
  I2 = (char ***)calloc(nb_comps,sizeof(char**));
  mI2 = (int *)calloc(nb_comps,sizeof(int));
  I3 = (int **)calloc(nb_comps,sizeof(int*));
  I4 = (int **)calloc(nb_comps,sizeof(int*));
  O0 = (char **)calloc(nb_comps,sizeof(char*));
  O1 = (char **)calloc(nb_comps,sizeof(char*));
  O2 = (char **)calloc(nb_comps,sizeof(char*));

  /* Filling in the data */
  if (fillInNetSolveData(nb_comps,comps,argv[1],
            I0,I1,mI0,I2,mI2,I3,I4,O0,O1,O2) == -1)
    exit(-1);

  /* Free some memory */
  for (i=0;i<nb_comps;i++)
    freeMCellComputationDesc(comps[i]);
  free(comps);

  /* Calling netsl_farm() */
  sprintf(buffer,"i=0,%d",nb_comps-1);
  status = netsl_farm(buffer,"mcell()",
       ns_ptr_array((void**)I0,"$i"),
       ns_ptr_array((void**)I1,"$i"),
       ns_int_array(mI0,"$i"),
       ns_ptr_array((void**)I2,"$i"),
       ns_int_array(mI2,"$i"),
       ns_ptr_array((void**)I3,"$i"),
       ns_ptr_array((void**)I4,"$i"),
       ns_ptr_array((void**)O0,"$i"),
       ns_ptr_array((void**)O1,"$i"),
       ns_ptr_array((void**)O2,"$i"));

  if (status[0] == -1)
  {
    fprintf(stderr,"Error: %s\n",netsolveErrorMessage(ns_errno));
    if (ns_errno == NetSolveFarmingError)
    {
      for(i=0;i<nb_comps;i++)
        fprintf(stderr,"requests %d: %s\n",
              i,netsolveErrorMessage(status[i]));
    }
    exit(-1);
  }

  fprintf(stderr,"All computations succesfully completed\n");
  fprintf(stderr,"OUTPUT files generated in appropriate directories\n");
  fprintf(stderr,"STDOUT files in the current directory\n");

  exit(1);
}
  
