#include <stdio.h>
#include <string.h>
#include "mcelldriver.h"
#include "netsolveutil.h"
#include <stdlib.h>

/*
 * constructMCellComputationDesc()
 */

NS_MCellComputationDesc *constructMCellComputationDesc(
	char *path,
	int seed,
        int iterations)
{
  NS_MCellComputationDesc *new;
  FILE *stream;
  char command[256];
  char line[256];

  new = (NS_MCellComputationDesc *)calloc(1,sizeof(NS_MCellComputationDesc));
  new->mdlfile = strdup(path);
  new->seed = seed;
  new->iterations = iterations;
 
  sprintf(command,"mcell -r %s %d",new->mdlfile,new->seed);
  stream = popen(command,"r");
  if (stream == NULL)
  {
    fprintf(stderr,"Impossible to run mcell -p\n");
    return NULL;
  }

  while(fgets(line,256,stream))
  {
    line[strlen(line)-1] = '\0';
    if (!strncmp(line,"INFILE: ",8)) 
    {
      new->nb_includefiles++;
      new->includefiles = (char **)myRealloc(new->includefiles,
               new->nb_includefiles*sizeof(char*));
      new->includefiles[new->nb_includefiles-1] = strdup(&(line[8]));
    }
    else if (!strncmp(line,"OUTFILE: ",9))
    {
      new->nb_outputfiles++; 
      new->outputfiles = (char **)myRealloc(new->outputfiles,
               new->nb_outputfiles*sizeof(char*));  
      new->outputfiles[new->nb_outputfiles-1] = strdup(&(line[9]));
    }
    else
      continue;
  }
  pclose(stream);
  return new;
}

/*
 * displayMCellComputationDesc()
 */
void displayMCellComputationDesc(NS_MCellComputationDesc *mcell)
{
  int i;

  fprintf(stdout,"MDL file: %s\n",mcell->mdlfile);
  fprintf(stdout,"Seed: %d\n",mcell->seed);
  fprintf(stdout,"Iterations: %d\n",mcell->iterations);
  fprintf(stdout,"%d included files\n",mcell->nb_includefiles);
  for (i=0;i<mcell->nb_includefiles;i++)
    fprintf(stdout,"--> %s\n",mcell->includefiles[i]);
  fprintf(stdout,"%d output files\n",mcell->nb_outputfiles);
  for (i=0;i<mcell->nb_outputfiles;i++)
    fprintf(stdout,"--> %s\n",mcell->outputfiles[i]);
  return;
}

/*
 * freeMCellComputationDesc()
 */
void freeMCellComputationDesc(NS_MCellComputationDesc *mcell)
{
  int i;
  for (i=0;i<mcell->nb_includefiles;i++)
    free(mcell->includefiles[i]);
  for (i=0;i<mcell->nb_outputfiles;i++)
    free(mcell->outputfiles[i]);
  free(mcell->includefiles);
  free(mcell->outputfiles);
  free(mcell->mdlfile);
  free(mcell);
  return;

}
