#include "mcelllib.h"
#include <stdio.h>
#include <strings.h>
#include <dirent.h>
#include <stdlib.h>

/*
 * gatherMCellOutput()
 *
 * Create the list of output filenames
 */
char **gatherMCellOutput(int oldn,char **outputs,int *newn)
{
  char **new=NULL;
  int i,j;
  char **exp;
  int nb;

  *newn = 0;

  for (i=0;i<oldn;i++)
  {
    exp = resolvePath(outputs[i],&nb);
    *newn += nb;
    new = (char **)myRealloc(new,(*newn)*sizeof(char*));
    for (j=0;j<nb;j++)
    {
      new[*newn -nb +j] = strdup(exp[j]);
      free(exp[j]);
    }
    free(exp);
  }

  return new;
}

/*
 * resolvePath()
 *
 *  x/v/d/f/ *.c =>  {a.c, b.c, erwer.c}
 */
char **resolvePath(char *path,int *nb)
{
  char **new=NULL;
  char *newpath;
  char *last_slash;
  char *filename,*dirname;
  DIR *dp;
  struct dirent *dir;
  
  *nb = 0;

  /* Prepend the path with './' */
  newpath = (char *)calloc(3+strlen(path),sizeof(char));
  newpath[0] = '.';
  newpath[1] = '/';
  strcpy(&(newpath[2]),path);

  /* find the last slash */
  last_slash = strrchr(newpath,'/');

  /* Fill in dirname and filename */
  filename = strdup((char *)(last_slash+1)); 
  *last_slash = '\0';
  dirname = strdup(newpath);
  free(newpath);

  /* Open the directory */
  if ((dp = opendir(dirname)) == NULL)
  {
    fprintf(stderr,"Impossible to open '%s'\n",dirname);
    *nb = 0;
    return NULL;
  }    
   
  /* Go through the files */
  while ((dir = readdir(dp)) != NULL)
  {
    
    if (isInstance(filename,dir->d_name))
    {
      (*nb)++;
      new = (char **)myRealloc(new,(*nb)*sizeof(char*));
      new[*nb - 1] = strdup(dir->d_name);
    }
  }
  closedir(dp);  
  free(dirname);
  free(filename);
  return new;
}

/*
 *  does toto.f correspond to *.f ? 
 */
int isInstance(char *expr, char *string)
{
  char *match;

  if (strchr(expr,'*') == NULL)
  {
    return (!strcmp(expr,string));
  }

  if ((expr[0] != '*')||(expr[1] != '.'))
  {
    fprintf(stderr,"For the moment, only '*.xxxx' expression supported\n");
  }

  match = strstr(string,&(expr[1]));
  while(1)
  {
    if (match == NULL)
      break;
    if (strlen(match) != strlen(&(expr[1])))
    {
      string = (char *)(string+strlen(&(expr[1])));
      match = strstr(string,&(expr[1]));
    }
    else
      break;
  }

  if (match == NULL)
    fprintf(stderr,"NO MATCH\n");
  else
    fprintf(stderr,"MATCH\n");
  return (match != NULL); 
}


