%{
#include "infoserver_int.h"
#include "iserv_parser.tab.h"

#undef YY_INPUT
#define YY_INPUT(b, r, ms) (r = buf_yyinput(b, ms))

#define YY_NO_UNPUT
%}

space    [ \t\r\n]+
alnums   [a-zA-Z0-9.,]+
qalnums  \"[^\"\n]*\"

%%

{space}      { }
and{space}+  { return TOK_AND; }
or{space}+   { return TOK_OR; }
=            { return TOK_EQUALITY; }
>            { return TOK_SUCCEEDS; }
get          { return TOK_GET; }
put          { return TOK_PUT; }
;            { return TOK_ENDQUERY; }
\(           { return TOK_LPAR; }
\)           { return TOK_RPAR; }
quit         { return TOK_QUITREQ; }
stat         { return TOK_STAT; }
{qalnums}    { char * i = yytext;
               yylval.text = yytext+1;
	       while(*i && *(i+1)) i++;
	       if(*i == '\"') *i = 0;
	       else fprintf(stderr, "Odd qalnums: \"%s\"\n", yytext);
	       return TOK_QALNUMS; }
{alnums}     { yylval.text = yytext; return TOK_ALNUMS; }
.            { yylval.text = yytext; return TOK_INVALID; }

%%

int yywrap(void) { return 1; }


