/*****************************************************************/
/*      pollfarmedrequest.c                                      */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  pollFarmedRequest()                                          */
/*****************************************************************/

/*
 * pollFarmedRequest()
 *
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

int pollFarmedRequest(int index,NS_ProblemDesc *pd,NS_RequestDesc **rds,
           NS_Object ***outputs,int *elapsed,void ***tmp_output_ptrs)
{
  int status;
  int j;

  status = netsolveProbeRequest(NS_NOASSIGNMENT, &(rds[index]));
  if (status == 1)
  {
    status = netsolveWaitRequest(NS_NOASSIGNMENT, &(rds[index]),elapsed);
    if (status == 1)
    {
      /* take output_ptrs of the strings in output */
      for (j=0;j<pd->nb_output_objects;j++)
      {
        if (outputs[index][j]->object_type != NETSOLVE_STRING)
          continue;
        strcpy(tmp_output_ptrs[index][j],
            outputs[index][j]->attributes.string_attributes.ptr);
        free(outputs[index][j]->attributes.string_attributes.ptr);
      }
    }
  }
  return ns_errno;
}
