/*****************************************************************/
/*      netsl_farmX.c                                             */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  netsl_farmX()                                                 */
/*****************************************************************/

/*
 * netsl_farmX() : low lovel no vararg stuff
 *
 * netsl_farmX()
 *
 *  We assume : start < end and step=+1
 */

#include <stdarg.h>
#include <unistd.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

int* netsl_farmX(int start,int end,NS_ProblemDesc *pd,NS_Iterator **iterator_array)
{
  int *statuses;
  int nb_requests;
  NS_RequestDesc **rds;
  NS_Object ***inputs;
  NS_Object ***outputs;
  void ***tmp_output_ptrs;
  int status;
  int i,j;
  int *returned_value;
  int nb_pending;
  int window_size;
  int none_pending;
  int elapsed=0;

  fprintf(stderr,"In netsl_farmX()\n");
  /* Initializing the major    */
  setMajorDefault("Row");

  /* Start the farming */
  nb_requests = end-start+1;
  statuses = (int *)calloc(nb_requests,sizeof(int));
  inputs   = (NS_Object ***)calloc(nb_requests,sizeof(NS_Object**));
  outputs  = (NS_Object ***)calloc(nb_requests,sizeof(NS_Object**));
  tmp_output_ptrs  = (void ***)calloc(nb_requests,sizeof(void**));
  rds      = (NS_RequestDesc **)calloc(nb_requests,sizeof(NS_RequestDesc*));

  /* Sending the requests */
  window_size = 8;
  nb_pending = 0;
  i = 0;
  none_pending=0;
  while(!none_pending)
  {
    fprintf(stderr,"%d pending requests\n",nb_pending);
    if ((i < nb_requests)&&(nb_pending < window_size))
    {
      statuses[i] = sendFarmedRequest(i,pd,inputs,outputs,iterator_array,
                      tmp_output_ptrs,rds);
      if (statuses[i] == NetSolveNotReady)
        nb_pending++;
      i++;
    }
    for (j=0;j<i;j++)
    {
      if (statuses[j] != NetSolveNotReady)
        continue;
      statuses[j] = pollFarmedRequest(j,pd,rds,outputs,&elapsed,tmp_output_ptrs);
      if (statuses[j] != NetSolveNotReady)
        nb_pending--;
    }
    if ((nb_pending == window_size)||(i == nb_requests))
      sleep(1);
    if ((i == nb_requests)&&(nb_pending == 0))
      none_pending = 1;
  }

  status = 1;
  for (i=0;i<nb_requests;i++)
  {
    if (statuses[i] != NetSolveOK)
      status = -1;
  }
  
  if (status == -1)
  {
    ns_errno = NetSolveFarmingError;
    returned_value = (int*)calloc(nb_requests+1,sizeof(int));
    returned_value[0] = -1;
    for (i=0;i<nb_requests;i++)
      returned_value[i+1] = statuses[i];
  }
  else
  {
    ns_errno = NetSolveOK;
    returned_value = (int*)calloc(1,sizeof(int));
    returned_value[0] = NetSolveOK;
  }

  /* Free Everything */
  for (i=0;i<nb_requests;i++)
  {
    for (j=0;j<pd->nb_input_objects;j++)
      freeObject(inputs[i][j]);
    for (j=0;j<pd->nb_output_objects;j++)
      freeObject(outputs[i][j]);
    free(inputs[i]);
    free(outputs[i]);
    freeRequestDesc(rds[i]);
    free(tmp_output_ptrs[i]);
  }
  free(inputs);
  free(outputs);
  free(statuses);
  free(tmp_output_ptrs);
  free(rds);
  return returned_value; 
}
