/*****************************************************************/
/*      constructIteratorArray.c                                 */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  constructIteratorArray()                                     */
/*****************************************************************/

/*
 * constructIteratorArray() : 
 *
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

int constructIteratorArray(va_list argptr,NS_ProblemDesc *pd,
                           NS_Iterator ***iterator_array,int start)
{
  int nb_args = pd->calling_sequence->nb_args;
  NS_Iterator **new;
  int i;

  new = (NS_Iterator**)calloc(nb_args,sizeof(NS_Iterator*));

  for (i=0;i<nb_args;i++)
  {
    new[i] = (NS_Iterator*)va_arg(argptr,void*); 
    new[i]->i = start;
  }

  *iterator_array = new;
  return 1;
}
