#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DEBUG 1

extern int netsl(char *nickname,...);

int construct_crs_system
(
 double **values,int **indices,int **pointers,int *nnzeros,
 int first,int local_size,int domain_size,int total_size,
 double **sol_vector,double **rhs_vector,double **tmp_vector);

int print_crs_matrix
(double *mv,int *idx,int *ptr, int domain_size,int local_size, int nnzeros,
		double* rhs_vector);

int print_result
(double *result, int local_size);

int main(int Argc,char **Args)
{
int status;
int total_size,domain_size,local_size,nnzeros,first;
/* return results */
int ierr;
/* the matrix */
int *pointers,*indices;
double *values,*sol_vector,*rhs_vector,*tmp_vector;
double rtol; int maxit,its;

  printf("Give domain size: ");
  scanf("%d",&domain_size);
  printf("\n");

  first = 0;
  total_size = domain_size * domain_size;
  local_size = total_size;

  construct_crs_system
    (&values,&indices,&pointers,&nnzeros,
     first,local_size,domain_size,total_size,
     &sol_vector,&rhs_vector,&tmp_vector);

#if DEBUG == 0
  ierr = print_crs_matrix(values,indices,pointers,domain_size, local_size, 
		nnzeros, rhs_vector);
  if (ierr) {
    printf("error in print_crs_matrix\n"); return 1;}
#endif


  printf("Relative tolerance : "); scanf("%lf",&rtol); printf("\n");
  printf("Maximum #iterations : "); scanf("%d",&maxit); printf("\n");

  status = netsl("itpack_solve()", total_size, nnzeros,
                values, indices, pointers, rhs_vector, &rtol,
                &maxit, sol_vector, &its);

  printf("ierr: %d\n", ierr);
#if DEBUG == 1
  printf("iteratons: %d\n", its);
#endif

#if DEBUG == 1
  ierr = print_result(sol_vector, local_size);
#endif

  return 0;

}

int construct_crs_system
(
 double **values,int **indices,int **pointers,int *nnzeros,
 int first,int local_size,int domain_size,int total_size,
 double **sol_vector,double **rhs_vector,double **tmp_vector)
{
  int IJ,ijk,i,j;

  *nnzeros = 5*total_size;
  /* allocate */
  *pointers = (int *) malloc((local_size+1)*sizeof(int));
  *indices = (int *) malloc((*nnzeros+1)*sizeof(int));
  *values = (double *) malloc((*nnzeros+1)*sizeof(double));
  *sol_vector = (double *) malloc(local_size*sizeof(double));
  *rhs_vector = (double *) malloc(local_size*sizeof(double));
  *tmp_vector = (double *) malloc(local_size*sizeof(double));

  IJ = 0; ijk = 0;
  for ( i=0; i<domain_size; i++ ) {
    for ( j=0; j<domain_size; j++ ) {
      int I,J; double v;
      if (IJ>=first && IJ<first+local_size) {
        (*rhs_vector)[IJ-first] = 1.;
        (*pointers)[IJ-first] = ijk;
        I = j + domain_size*i;
        v = -1.0;
        if ( i>0 ) {
          J = I - domain_size;
          (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
        }
        if ( j>0 )   {
          J = I - 1;
          (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
        }
        {
          double v = 4.0;
          (*values)[ijk] = v; (*indices)[ijk] = I; ijk++;
        }
        if ( j<domain_size-1 ) {
          J = I + 1;
          (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
        }
        if ( i<domain_size-1 ) {
          J = I + domain_size;
          (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
        }
      }
      IJ++;
    }
  }
  (*pointers)[local_size] = ijk;

  return 0;
}

int print_crs_matrix
(double *mv,int *idx,int *ptr, int domain_size,int local_size, int nnzeros,
		double* rhs_vector)
{
int i;
      printf("values: \n");
      for(i=0;i< nnzeros+1;i++)
          printf("%f   ", mv[i]);
      printf("\n");
      printf("indices:\n");
      for(i=0;i< nnzeros+1;i++)
          printf("%d  ", idx[i]);
      printf("\n");
      printf("ptrs:\n");
      for(i=0;i<local_size+1;i++){
          printf("%d\t", ptr[i]);
      }
      printf("\n");
      printf("rhs:\n");
      for(i=0;i<local_size;i++){
          printf("%f\t", rhs_vector[i]);
      }
      printf("\n");

  return 0;
}

int print_result
(double *result, int local_size)
{
int i;
      printf("values: \n");
      for(i=0;i< local_size;i++)
          printf("%f   ", result[i]);
      printf("\n");

   return 0;
}
