/*
Fri Aug 15 16:29:47 EDT 1997

                       ***   SAMPLE USAGE    ***
                    For Harwell I/O package iohb.c.

           National Institute of Standards and Technology, MD.
                             K.A. Remington

++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                                NOTICE

 Permission to use, copy, modify, and distribute this software and
 its documentation for any purpose and without fee is hereby granted
 provided that the above copyright notice appear in all copies and
 that both the copyright notice and this permission notice appear in
 supporting documentation.

 Neither the Author nor the Institution (National Institute of Standards
 and Technology) make any representations about the suitability of this 
 software for any purpose. This software is provided "as is" without 
 expressed or implied warranty.
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
#include<stdlib.h>
#include<stdio.h>
#include "iohb.h"

int netsl(char *,...);

int main(int argc, char *argv[])
{
char which[10];
int info;
int total_size,domain_size, wanted, which_selection;
/* return results */
double *real_ev, *imag_ev, *vectors;

   int status;
   int M, N, nonzeros, Nrhs;
   int *colptr, *rowind;
   double *val;
   char *Type;
   int i;

  printf("Number of eigenvectors: "); scanf("%d",&wanted); printf("\n");
  printf("Enter 1 .. 7\n");
  printf("1. Largest   2. Smallest  3. Largest reals  4. Smallest reals\n");
  printf("5. Largest imag.  6. Smallest imag. 7. Shift:");
  scanf("%d", &which_selection);
  if(which_selection == 1)
    strcpy(which, "LM");
  else if(which_selection == 2)
    strcpy(which, "SM");
  else if(which_selection == 3)
    strcpy(which, "LR");
  else if(which_selection == 4)
    strcpy(which, "SR");
  else if(which_selection == 5)
    strcpy(which, "LI");
  else if(which_selection == 6)
    strcpy(which, "SI");
  else if(which_selection == 7)
    strcpy(which, "shift");
  else{
    printf("wrong selection\n");
    return -1;
  }
 
  real_ev = (double*) malloc((wanted+1)*sizeof(double));
  imag_ev = (double*) malloc((wanted+1)*sizeof(double));
  vectors = (double*) malloc(total_size*wanted*sizeof(double));

/* Get information about the array stored in the file specified in the  */
/* argument list:                                                       */

   fprintf(stderr,"Reading matrix info from %s...\n",argv[1]);
   readHB_info("../matmarket/data/bfw398a.rua", &M, &N, &nonzeros, &Type, &Nrhs);

   fprintf(stderr,"Matrix in file %s is %d x %d, with %d nonzeros with type %s;\n",
                         argv[1], M, N, nonzeros, Type);
   fprintf(stderr,"%d right-hand-side(s) available.\n",Nrhs);

/* Read the matrix information, generating the associated storage arrays  */ 
   fprintf(stderr,"Reading the matrix from %s...\n",argv[1]);
   readHB_newmat_double("../matmarket/data/bfw398a.rua", &M, &N, &nonzeros, &colptr, &rowind, &val);

   total_size = domain_size = M;
   
  printf("%d %d %d\n", M, N, nonzeros);
  
/* If a rhs is specified in the file, read one, generating the associate storage */

  status = netsl("arpack_solver()", total_size, nonzeros,
                val, rowind, colptr, &wanted, which, real_ev, imag_ev, 
		vectors, &info);

  printf("real:\n");
  for(i=0; i< wanted; i++)
    printf("%f ", real_ev[i]);
  printf("\n");
  printf("imag:\n");
  for(i=0; i< wanted; i++)
    printf("%f ", imag_ev[i]);
  printf("\n");

  return 0;
 
}
