/*****************************************************************/
/*      farming.c                                                */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/* The example probgram using the NetSolve farming feature to    */
/* performs a bunch of redundant Matrix multiplies		 */
/*                                                               */
/* The matrix is stored column-wise in Fortran fashion           */
/*                                                               */
/* The problem 'dmatmul' should be availalbe on a server.        */
/*                                                               */
/*****************************************************************/

#include "netsolve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

double *createMatrix(int);
void printMatrix(double*,int,int,int);

#define EPSILON 0.000001

/*
 * main()
 */
int main(int argc, char **argv)
{
  time_t date1,date2;
  int NSstatus;
  int n,*status,i,j;
  int blocksize;
  double *a;
  double *asquare;
  int nb_requests;
  char buf[32];
  int *nI0,*nI1,*mI0,*lI0,*lO0,*lI1;
  double **I0,**I1,**O0;

  if (argc != 3)
  {
    fprintf(stderr,"Usage: %s <matrix size> <number of requests>\n",argv[0]);
    exit(-1); 
  }
  n = atoi(argv[1]);
  nb_requests = atoi(argv[2]);
 
  if ((n<=0)||(nb_requests<=0))
  {
    fprintf(stderr,"Invalid arguments\n");
    exit(-1);
  }

  a = createMatrix(n);
  asquare = (double*)calloc(n*n,sizeof(double));

  /* Allocate the farming memory */
  mI0 = (int *)calloc(nb_requests,sizeof(int));
  nI1 = (int *)calloc(nb_requests,sizeof(int));
  nI0 = (int *)calloc(nb_requests,sizeof(int));
  I0 = (double **)calloc(nb_requests,sizeof(double*));
  lI0 = (int *)calloc(nb_requests,sizeof(int));
  I1 = (double **)calloc(nb_requests,sizeof(double*));
  lI1 = (int *)calloc(nb_requests,sizeof(int));
  lO0 = (int *)calloc(nb_requests,sizeof(int));
  O0 = (double **)calloc(nb_requests,sizeof(double*));

  /* Set up the pointers and integers */
  for (i=0;i<nb_requests;i++)  
  {
    mI0[i] = n;
    nI1[i] = n;
    nI0[i] = n;
    I0[i] = a;
    lI0[i] = n;
    I1[i] = a;
    lI1[i] = n;
    lO0[i] = n;
    O0[i] = asquare;
  }
      
  /* Call netsl_foral() */
  netslmajor("Col");

  sprintf(buf,"i=0,%d",nb_requests-1);
  fprintf(stderr,"Farming requests with NetSolve...\n");
  time(&date1);
  status = netsl_farm(buf,"dmatmul()",ns_int_array(mI0,"$i"),
                                        ns_int_array(nI1,"$i"),
                                        ns_int_array(nI0,"$i"),
                                        ns_ptr_array((void**)I0,"$i"),
                                        ns_int_array(lI0,"$i"),
                                        ns_ptr_array((void**)I1,"$i"),
                                        ns_int_array(lI1,"$i"),
                                        ns_int_array(lO0,"$i"),
                                        ns_ptr_array((void**)O0,"$i"));
  time(&date2);
  fprintf(stderr,"Elapsed: %d\n",(int)date2-(int)date1);
                                         
  if (status[0] != NetSolveOK)
  {
    for (i=1;i<=nb_requests;i++)
    {
      fprintf(stderr,"Requests #%d:",i);
      netslerr(status[i]);
    }
    
    netslerr(status[0]);
    exit(-1);
  }
  fprintf(stderr,"Done.\n");
 
  fprintf(stderr," ** Success **\n");
  return 1;
}

/*
 * createMatrix()
 */
double *createMatrix(int n)
{
  int i;
  double *new;
  int init = 1325;

  new = calloc(n*n,sizeof(double));
  for (i=0;i<n*n;i++)
  {
    init = 2315*init % 65536;
    new[i] = (double)((double)init - 32768.0) / 16384.0; 
  }
  return new;
}

/*
 * printMatrix()
 */
void printMatrix(double *a,int m,int n,int lda)
{
  int i,j;

  for (i=0;i<m;i++)
  {
    for (j=0;j<n;j++)
      fprintf(stderr,"%f ",a[j*lda+i]);
    fprintf(stderr,"\n");
  }
}
