#include "core.h"

DSI_OBJECT* ns_dsi_write_vector(DSI_FILE* dsi_file, void* data, int count, 
			int data_type){
#ifdef DSI
char* tmpbuf;
int write_allowed;
int perm;
int extent, length;
int return_value;
uid_t my_uid;
DSI_OBJECT* dsi_obj;

#ifdef DSI_IBP
struct ibp_timer ls_timeout;
#endif

  ns_errno = 0;
  tmpbuf = (char*)data;
  extent = netsolve_sizeof(data_type);

  length = count*extent;

  my_uid = getuid();

  if(my_uid == dsi_file->uid){
    perm = dsi_file->perm / 100;
  }
  else{
    perm = dsi_file->perm % 10;
  }
  
  write_allowed = perm & 2;

  if(write_allowed && ((dsi_file->flag&O_WRONLY) || 
			(dsi_file->flag&O_RDWR))){

    if(dsi_file->storage_system == IBP){

#ifdef DSI_IBP

      ls_timeout.ServerSync = 10;
      ls_timeout.ClientTimeout = 10;

      return_value = IBP_store(
                               dsi_file->dsi_specifics.ibp.cap->writeCap, 
                               &ls_timeout, tmpbuf, length);
      if(return_value == 0){
        ns_errno = NetSolveIBPStoreError;
        return NULL;
      }
#endif
      
    }
  
    dsi_obj = (DSI_OBJECT*)malloc(sizeof(DSI_OBJECT));
    dsi_obj->offset = dsi_file->written_count;
    dsi_obj->dsi_file = dsi_file;
    dsi_file->written_count += length;
    return_value = insert_dsi_object(dsi_obj);
    if(return_value == 1)
      return dsi_obj;
    else
      return NULL;
  }
  else{
    ns_errno = NetSolveDsiEACCESS;
    return NULL;
  }
#endif
  ns_errno = NetSolveDsiDisabled;
  return NULL;

}

DSI_OBJECT* ns_dsi_write_matrix(DSI_FILE* dsi_file, void* data, int rows, 
			int cols, int data_type){

  return ns_dsi_write_vector(dsi_file, data, rows*cols, data_type);

}
