#include "core.h"

DSI_FILE* ns_dsi_open(char* host_name, int flag, int permissions, int
                      size, dsi_type storage_system){
#ifdef DSI
uid_t my_uid;
DSI_FILE* dsi_file;
#ifdef DSI_IBP
IBP_depot depot;
IBP_set_of_caps cap;
IBP_attributes attr;
struct ibp_timer ls_timeout;
#endif

  ns_errno = 0;
  my_uid = getuid();

  /* the file is not present */
  if(!(flag & O_CREAT)){
    ns_errno = NetSolveUnknownDsiFile;
    return NULL;
  }
  else{
    if(storage_system == IBP){
#ifdef DSI_IBP

      ls_timeout.ServerSync = 10;
      ls_timeout.ClientTimeout = 10;

      depot = (IBP_depot)malloc(sizeof(struct ibp_depot));
      attr = (IBP_attributes)malloc(sizeof(struct ibp_attributes));

      attr->duration = 0;
      attr->reliability = IBP_STABLE;
      attr->type = IBP_BYTEARRAY;

      strcpy(depot->host, host_name);
      depot->port = 6716;

      cap = IBP_allocate(depot, &ls_timeout, size, attr);

      if(cap == NULL){
        ns_errno = NetSolveIBPAllocateError; 
        return NULL;
      }
#endif

      dsi_file = (DSI_FILE*)malloc(sizeof(DSI_FILE));
      dsi_file->flag = flag;
      dsi_file->perm = permissions;
      dsi_file->uid = my_uid;
      dsi_file->storage_system = IBP;
    #ifdef DSI_IBP
      dsi_file->dsi_specifics.ibp.depot = depot;
      dsi_file->dsi_specifics.ibp.cap = cap;
    #endif
      dsi_file->written_count = 0;

      insert_dsi_file(dsi_file);

      return dsi_file;
    }
  }

#endif
  ns_errno = NetSolveDsiDisabled;
  return NULL;
}
