#include "dsi.h"
#include "core.h"

int ns_dsi_close(DSI_FILE* dsi_file){
#ifdef DSI
#ifdef DSI_IBP
  struct ibp_timer ls_timeout;
  struct ibp_capstatus ls_info;
  int rtn;

  ns_errno = 0;
  ls_timeout.ServerSync = 10;
  ls_timeout.ClientTimeout = 10;

  rtn=IBP_manage(dsi_file->dsi_specifics.ibp.cap->manageCap,
                 &ls_timeout, IBP_DECR, IBP_READCAP,
                 &ls_info);

  if(rtn == -1)
    ns_errno = NetSolveIBPManageError;
  return rtn;
#endif
  ns_errno = 0;
  remove_dsi_file(dsi_file);
#endif

  ns_errno = NetSolveDsiDisabled;
  return 1;
}
