/*****************************************************************/
/*      pong.c                                                   */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include <sys/time.h>
#include "general.h"
#include "core.h"
#include "protocol.h"
#include "pong.h"

/*
 * doPong()
 *
 * pings a server/agent
 */
void doPong(char *hostname, NS_IPaddr_type IPaddr, int port,
           int *latency, int *bandwidth)
{
  int i;
  int l,b;
  int suml,sumb;

  suml = 0;
  for (i=0;i<PONG_LATENCY_MEASUREMENTS;i++)
  {
    l = getLatency(hostname,IPaddr,port);
    if (l == -1)
    {
      suml = -PONG_LATENCY_MEASUREMENTS;
      break;
    }
    suml += l;
  }
  *latency = suml/PONG_LATENCY_MEASUREMENTS;

  sumb = 0;
  for (i=0;i<PONG_BANDWIDTH_MEASUREMENTS;i++)
  {
    b = getBandwidth(hostname,IPaddr,port);
    if (b == -1)
    {
      sumb = -PONG_BANDWIDTH_MEASUREMENTS;
      break;
    }
    sumb += b;
  }
  *bandwidth = (int)((1000000.*(double)BANDWIDTH_DATA_SIZE 
              * (double)PONG_BANDWIDTH_MEASUREMENTS)/(double)sumb);
  return;
}

/*
 * getLatency()
 *
 * Gets ONE latency measurement.
 */
int getLatency(char *hostname, NS_IPaddr_type IPaddr, int port)
{
  int sock;
  NS_Communicator *comm;
  struct timeval tv[2];
  int dt;
  
  gettimeofday(&tv[0], (struct timezone*)0);
  sock = connectToSocket(hostname,IPaddr,port);
  if (sock < 0)
    return -1;
  comm = initTransaction(sock,DATA_XDR);
  if (sendInt(comm,NS_PROT_PONG_LATENCY) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  endTransaction(comm);
  gettimeofday(&tv[1], (struct timezone*)0);
  dt = ((tv[1].tv_sec - tv[0].tv_sec) * 1000000
         + tv[1].tv_usec - tv[0].tv_usec);
  return dt;
}

/*
 * getBandwidth()
 */
int getBandwidth(char *hostname, NS_IPaddr_type IPaddr, int port)
{
  int sock;
  NS_Communicator *comm;
  struct timeval tv[2];
  int size=BANDWIDTH_DATA_SIZE;
  static char data[BANDWIDTH_DATA_SIZE];
  int dt;


  gettimeofday(&tv[0], (struct timezone*)0);
  sock = connectToSocket(hostname,IPaddr,port);
  if (sock < 0)
    return -1;
  comm = initTransaction(sock,DATA_XDR);
  if (sendInt(comm,NS_PROT_PONG_BANDWIDTH) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  if (sendInt(comm,size) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  if (sendArray(comm,NETSOLVE_CHAR,data,size) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  if (recvArray(comm,NETSOLVE_CHAR,data,size) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  endTransaction(comm);
  gettimeofday(&tv[1], (struct timezone*)0);
  dt = ((tv[1].tv_sec - tv[0].tv_sec) * 1000000
         + tv[1].tv_usec - tv[0].tv_usec);
  return dt/2;

}
