/*****************************************************************/
/*      node.c                                                   */
/*      Version 1.0                      Dieter Bachmann         */
/*---------------------------------------------------------------*/
/* manipulation of the node structure 

int      netsl_insert_Node(NS_Node); insert new node 
int      netsl_delete_Nodes();       delete all nodes 
NS_Node* netsl_new_Node();           geneate new node 

                                                   
******************************************************************/

#include "netsolveclient.h"
#include <unistd.h>

/*
 * Uncomment the following definition to debug the
 * dependency analysis
 *
 * #define DEPENDENCIES_DEBUG 
 */

NS_Dep* netsl_new_Dep (int size){

    NS_Dep *tmp_dep;
    int     i;

    /* alloc & dependency */
    tmp_dep = malloc(sizeof(NS_Dep));  
    if (tmp_dep == NULL) {
	fprintf (stderr, "Faild to allocate in_dep \n");
	return NULL;
    } /* if */

    /* allocate inut dependencies and set them to 0 */
    tmp_dep->size = size;
    tmp_dep->dest_node = malloc(size * sizeof(int)); 
    tmp_dep->dest_arg  = malloc(size * sizeof(int)); 
    tmp_dep->dep_type  = malloc(size * sizeof(int)); 

    for (i=0; i< size; i++){
	tmp_dep->dest_node[i] = -1;
	tmp_dep->dest_arg[i] = -1;
	tmp_dep->dep_type[i] = NETSOLVE_NO_DEPENDENCY;
    } /* for */

    return tmp_dep;
} /*  netsl_new_Dep  */


NS_Node* netsl_new_Node(){           /* geneate new node */

  NS_Node *tmp_node;

  /*  fprintf(stderr,"Generating New Node\n"); */
  tmp_node = malloc(sizeof(NS_Node));   /* alloc node */
  if (tmp_node == NULL) {
    fprintf (stderr, "Faild to allocate Node \n");
    return NULL;
  } /* if */

  tmp_node->last = NULL;  /* set all links to NULL */
  tmp_node->next = NULL;
  tmp_node->id = 0;
  
  tmp_node->pd = NULL;


  tmp_node->out_dep = NULL;
  tmp_node->in_dep =  NULL; 

  tmp_node->input_size = 0;
  tmp_node->output_size = 0;
  tmp_node->problem_size = 0;

  tmp_node->tmp_output_ptr = NULL;
  tmp_node->servers = NULL;



  return tmp_node;
} /*  netsl_new_Node(NS_ProblemDesc* pd)  */


NS_Node* netsl_new_Node_Dep(NS_ProblemDesc* pd, int inputs, int outputs){

    NS_Node *tmp_node = netsl_new_Node();

    tmp_node->pd = pd;    /* add problem description */

    /* alloc input &  output dependencies */
    tmp_node->out_dep = netsl_new_Dep(outputs); 
    tmp_node->in_dep =  netsl_new_Dep(inputs); 

  return tmp_node;

}


int netsl_delete_Nodes(NS_Node *top_Node){       /* delete all nodes */

  NS_Node *tmp_node;
  NS_Node *next_node;

  tmp_node = top_Node;

  if (tmp_node == NULL) {
     fprintf(stderr,"Nothing to delete\n"); 
     return FALSE;
  }

  next_node = tmp_node->next;

  /* delete all items */
  while (tmp_node != NULL) {
    next_node = tmp_node->next;
    if (tmp_node->in_dep != NULL){
	free (tmp_node->in_dep->dest_node);
	free (tmp_node->in_dep->dest_arg);
	free (tmp_node->in_dep->dep_type);
	free (tmp_node->in_dep);
    }


    if (tmp_node->out_dep != NULL){
	free (tmp_node->out_dep->dest_node);
	free (tmp_node->out_dep->dest_arg);
	free (tmp_node->out_dep->dep_type);
	free (tmp_node->out_dep);
    }
    
    if (tmp_node->servers == NULL) free(tmp_node->servers);
    if (tmp_node->tmp_output_ptr == NULL) free(tmp_node->tmp_output_ptr);

    freeProblemDesc (tmp_node->pd);
    free (tmp_node);
    tmp_node = next_node;

  


  }
    
 return TRUE;

} /* netsl_delete_nodes */


int netsl_insert_Node(NS_Node *new_node, NS_Node **top_Node){ /* insert new node */
  NS_Node *tmp_node;

  /*  fprintf(stderr,"Insert New Node\n"); */

  if (new_node == NULL) { 
    fprintf(stderr, "No node to insert\n"); 
    return FALSE;
  }/* if */

  if (*top_Node == NULL) {  /* no root node, assigning new_node */
      /*    fprintf(stderr, "No node root Node\n");  */
    *top_Node = new_node;
    new_node -> id = 0;  /* set the id to 0 */
    return TRUE;
  }/* if */

  tmp_node = *top_Node;

  /* go to last node */
  while (tmp_node->next != NULL){
    tmp_node = tmp_node->next;
  } /* while */
  /* insert node dopuble linked list*/
  tmp_node->next = new_node;
  new_node->last = tmp_node;
  new_node->next=NULL;
  new_node->id = tmp_node->id + 1;   /* set the problem id */
  return TRUE;
} /* netsl_insert_Node(NS_Node* newNode) */


/* get the number of nodes in a sequence */
int netsl_get_nb_Nodes (NS_Node* top_node){

    int i = 0;
    while(top_node != NULL) {
	top_node = top_node->next;
	i++;
    }
    return i;
} /* netsl_get_nb_Nodes */


/* sending a node structure over the network */
/* comm     : channel to communicate */
/* top_node : root of the node structure */


int netsl_send_Dependencies ( NS_Communicator *comm, NS_Dep *dep){

    int i = 0;

    if (sendInt(comm, dep->size) == -1)    /* number of dependencies */
	return -1;

    for (i = 0; i < dep->size; i++ ){   /* process dependency list */
	if (sendInt(comm, dep->dest_node[i]) == -1)
	    return -1;
	if (sendInt(comm, dep->dest_arg[i]) == -1)
	    return -1;
	if (sendInt(comm, dep->dep_type[i]) == -1)
	    return -1;
    } /* for all entries */

    return 0;
} /* netsl_send_Dependencies ( NS_Communicator, NS_Dep ) */

NS_Dep* netsl_recv_Dependencies ( NS_Communicator *comm){
    int i = 0;
    int size ;
    NS_Dep *tmp_dep;

    if (recvInt(comm, &size) == -1){    /* number of dependencies */
      ns_printinfo();
      netsolvePerror("recvInt()");
      return 0;
    }

    tmp_dep = netsl_new_Dep(size);
/*      fprintf(stderr, "pid %i receiving %d dependencies...\n", getpid(), size); */

    for (i = 0; i < tmp_dep->size; i++ ){   /* process dependency list */
	if ((recvInt(comm, &tmp_dep->dest_node[i]) == -1) ||
	    (recvInt(comm, &tmp_dep->dest_arg[i])  == -1) || 
            (recvInt(comm, &tmp_dep->dep_type[i]) == -1)){	    
              ns_printinfo();
  	      netsolvePerror ("recvInt()");
	      return 0;
	}
#ifdef DEPENDENCIES_DEBUG
	fprintf(stderr, "dep %d is node(%d):arg(%d):type(%d)\n", i,
		tmp_dep->dest_node[i], tmp_dep->dest_arg[i], tmp_dep->dep_type[i]);
#endif

    } /* for all entries */
    return tmp_dep;

} /* netsl_send_Dependencies ( NS_Communicator, NS_Dep ) */



int netsl_send_Nodes (NS_Communicator *comm, NS_Node *top_node){

    int nb_nodes; /* number of nodes */
    int i = 0;

    nb_nodes = netsl_get_nb_Nodes(top_node);

    if (sendInt(comm, nb_nodes) == -1)    /* number of nodes */
	return -1;

    for (i=0; i< nb_nodes; i++){ /* for all nodes */
	if (top_node == NULL){
	    fprintf(stderr,"No top-node, nothing to send!\n");
	    return -1;
	}

	if (sendInt(comm, top_node->id) == -1) 
	    return -1;

	if (sendInt(comm, top_node->input_size) == -1)  
	    return -1;

	if (sendInt(comm, top_node->output_size) == -1) 
	    return -1;

	if (sendInt(comm, top_node->problem_size) == -1)
	    return -1;



	if (sendProblemDesc(comm, top_node->pd) == -1)  /* problem description */
	    return -1;

	if (netsl_send_Dependencies( comm, top_node->in_dep) == -1)    /* input dependencies  */
	    return -1;

	if (netsl_send_Dependencies( comm, top_node->out_dep) == -1)    /* input dependencies  */
	    return -1;
	top_node = top_node->next;
    } /* for all nodes */

      
    return 0;
} /* netsl_send_Nodes(NS_Communicator, NS_Node) */

NS_Node* netsl_recv_Node (NS_Communicator *comm) {


    int nb_nodes; /* number of nodes */
    int i = 0;
    NS_Node *top_node  = NULL;
    NS_Node *last_node = NULL;
    NS_Node *tmp_node  = NULL;


    if (recvInt(comm, &nb_nodes) == -1){    /* number of nodes */
        ns_printinfo();
	netsolvePerror ("recvInt()");
	return 0;
    }



    for (i=0; i< nb_nodes; i++){ /* for all nodes */

	tmp_node = netsl_new_Node(); /* create a node */


       if ((recvInt( comm, &tmp_node->id ) == -1)||  /* problem description */
	   (recvInt( comm, &tmp_node->input_size) == -1)||      /* input dependencies  */
	   (recvInt( comm, &tmp_node->output_size) == -1)||      /* input dependencies  */
	   (recvInt( comm, &tmp_node->problem_size) == -1)){      /* input dependencies  */
         ns_printinfo();
	      netsolvePerror ("recvInt()");
	      return 0;
       } /* if */

       if (((tmp_node -> pd = recvProblemDesc( comm )) == NULL)||  /* problem description */
	   ((tmp_node -> in_dep = netsl_recv_Dependencies( comm )) == NULL)||      /* input dependencies  */
	   ((tmp_node -> out_dep = netsl_recv_Dependencies( comm )) == NULL)) {    /* input dependencies  */
              ns_printinfo();
	      netsolvePerror ("recvProblemDesc()");
	      return 0;
       } /* if */

       if (last_node == NULL) { /* first node to insert */
	   top_node  = tmp_node;
	   last_node = tmp_node;
       } 
       else {
	   last_node->next = tmp_node;   /* connect_nodes */
	   tmp_node ->last = last_node;
	   last_node = tmp_node;
       }

			   
    } /* for all nodes */
    return top_node;
}
