/*****************************************************************/
/*      netsolvesignals.c                                        */
/*      Henri Casanova, Dorian Arnold                                        */
/*---------------------------------------------------------------*/
/*  signal()     from Unix Network Programming (Vol. 1)          */
/*  setSignals()                                                 */
/*  evilsig()     from PVM                                       */
/*  catch()       from PVM                                       */
/*  biteme()      from PVM                                       */
/*  reap()        from PVM                                       */
/*****************************************************************/

#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "netsolvesignals.h"
#include "abort.h"

Sigfunc *
signal(int signo, Sigfunc *func)
{
  struct sigaction act, oact;

  act.sa_handler = func;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  if (signo == SIGALRM) {
#ifdef SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT;   /* SunOS 4.x */
#endif
  }
  else {
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;    /* SVR4, 4.4BSD */
#endif
  }
  if (sigaction(signo, &act, &oact) < 0 )
    return (SIG_ERR);

  return(oact.sa_handler);
}
  
/*
 * setSignals()
 */
int
setSignals()
{

#ifdef  SIGCHLD
  (void)signal(SIGCHLD,sig_chld);
#else
  (void)signal(SIGCLD,sig_chld);
#endif 

  if (signal(SIGINT, SIG_IGN) != SIG_IGN)
    (void)signal(SIGINT, catch);
  if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
    (void)signal(SIGTERM, catch);

  (void)signal(SIGHUP, SIG_IGN);
  (void)signal(SIGPIPE, SIG_IGN);
  (void)signal(SIGALRM, timeout);
  /*
   * You can set this define in the top of
   * this file if you want - but beware, catching
   * SIGSEGV (and friends) causes undefined 
   * behavior - we usually want a core dump instead
   */
#ifdef ACCEPT_UNDEFINED_BEHAVIOR
  (void)signal(SIGILL, evilsig);
  (void)signal(SIGSEGV, evilsig);
  (void)signal(SIGFPE, evilsig);
#ifdef  SIGBUS
  (void)signal(SIGBUS, evilsig);
#endif
#endif
#ifdef  SIGSYS
  (void)signal(SIGSYS, evilsig);
#endif

#ifdef SIGDANGER
  (void)signal(SIGDANGER,biteme);
#endif

  return 1;
}

/*
 * evilsig() : From PVM  Bob Manchek
 */
void evilsig(int sig)
{
  fprintf(stderr,"evilsig() caugth signal %d\n",sig);
  Abort();
}

/*
 * catch() : From PVM  Bob Manchek
 */
void catch(int sig)
{
  fprintf(stderr,"catch() caught signal %d\n",sig);
  Abort();
}

/*
 * biteme() : Form PVM  Bob Manchek
 */
#ifdef SIGDANGER
void biteme(int sig)
{
#ifdef VIEW
  fprintf(stderr,"biteme() caught signal %d\n",sig);
  fprintf(stderr,"Don't panic... it's an RS6K !!!!!\n");
#endif
}
#endif /* SIGDANGER */

/* 
 * sig_chld() : from UNIX Network Programming Vol. 1
 */

void sig_chld(int signo)
{
  int stat;

  while( waitpid(-1, &stat, WNOHANG) > 0);
  
  return;
}

void timeout(int signo)
{
  return;
}
