/*****************************************************************/
/*      netsolveerror.c						 */
/*      Henri Casanova						 */
/*****************************************************************/

#include "core.h"

/*
 * netsolvePerror()
 */
/* void ns_perror(char *string)
{
  fprintf(STDERR "%s %s\n",string, netsolveErrorMessage(ns_errno));
  return;
} */

/*
 * netsolveErrorMessage()
 */
char *netsolveErrorMessage(int e)
{
  switch(e)
  {
    case NetSolveBadIterationRange:
      return (" Invalid iteration range");
      break;
    case NetSolveCannotContactAgent:
      return (" Cannot contact agent");
      break;
    case NetSolveProxyError:
      return (" Error while talking to proxy");
      break;
    case NetSolveUnknownServer:
      return (" Unknown server");
      break;
    case NetSolveCannotStartProxy:
      return (" Cannot start proxy");
      break;
    case NetSolveFarmingError:
      return (" One or more requests failed");
      break;
    case NetSolveOK:
      return (" no error");
      break;
    case NetSolveCondorError:
      return (" Condor error");
      break;
    case NetSolveConnectionRefused:
      return (" connection refused");
      break;
    case NetSolveUPFUnsafe:
      return (" UPF security violation");
      break;
    case NetSolveServerError:
      return (" server error");
      break;
    case NetSolveUPFError:
      return (" impossible to compile UPF");
      break;
    case NetSolveCannotBind:
      return (" impossible to bind to port");
      break;
    case NetSolveSystemError:
      return (" system error");
      break;
    case NetSolveUnknownError:
      return (" unknown error");
      break;
    case NetSolveSetNetSolveArch:
      return (" NETSOLVE_ARCH not set");
      break;
    case NetSolveSetNetSolveAgent:
      return (" NETSOLVE_AGENT not set");
      break;
    case NetSolveSetNetSolveRoot:
      return (" NETSOLVE_ROOT not set");
    case NetSolveInternalError:
      return (" internal error");
      break;
    case NetSolveMismatch:
      return (" inconsistent object transfers");
      break;
    case NetSolveUnknownHost:
      return (" Unknown host");
      break;
    case NetSolveInvalidUPFFilename:
      return (" invalid upf filename");
      break;
    case NetSolveNetworkError:
      return (" network error");
      break;
    case NetSolveUnknownProblem:
      return (" unknown problem");
      break;
    case NetSolveProtocolError:
      return (" protocol error");
      break;
    case NetSolveNoServer:
      return (" no available server");
      break;
    case NetSolveBadProblemSpecification:
      return (" bad problem input/output");
      break;
    case NetSolveNotAllowed:
      return (" not allowed");
      break;
    case NetSolveBadValues:
      return (" bad input values");
      break;
    case NetSolveDimensionMismatch:
      return (" dimension mismatch");
      break;
    case NetSolveNoSolution:
      return (" no solution");
      break;
    case NetSolveNotReady:
      return (" not ready");
      break;
    case NetSolveInvalidRequestID:
      return (" invalid request ID");
      break;
    case NetSolveBadProblemName:
      return (" invalid problem name");
      break;
    case NetSolveInvalidMajor:
      return (" invalid major specification");
      break;
    case NetSolveTooManyPendingRequests:
      return (" too many pending requests");
      break;
    case NetSolveFileError:
      return (" file I/O error");
      break;
    case NetSolveUnknownDataFormat:
      return (" unknown machine type");
      break;
    case NetSolveTimedOut:
      return (" operation timed out");
      break;
    case NetSolveUnknownDsiFile:
      return (" DSI file not found");
      break;
    case NetSolveIBPAllocateError:
      return (" error in IBP_Allocate");
      break;
    case NetSolveIBPManageError:
      return (" error in IBP_Manage");
      break;
    case NetSolveIBPLoadError:
      return (" error in IBP_Load");
      break;
    case NetSolveIBPStoreError:
      return (" error in IBP_Store");
      break;
    case NetSolveDsiEACCESS:
      return (" permission denied to DSI file");
      break;
    case NetSolveDsiDisabled:
      return (" NetSolve not configured with DSI");
      break;
    case NetSolveAuthenticationError:
      return (" Authentication to server failed");
      break;
    default:
      return (" unknown error");
      break;
  }
}
