/*****************************************************************/
/*      linkedlist.c                                             */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"

/*
 * newNSLinkedList()
 *
 * Mallocs a new linked list
 */
NS_LinkedList *newNSLinkedList()
{
  return (NS_LinkedList *)calloc(1,sizeof(NS_LinkedList));
}

/*
 * newNSLinkItem()
 *
 * Mallocs a new item for a linked list 
 */
NS_LinkItem *newNSLinkItem(void *value)
{
  NS_LinkItem *new;

  new = (NS_LinkItem *)calloc(1,sizeof(NS_LinkItem));
  new->content = value;
  return new;
}

/*
 * NScountList()
 *
 * counts the number of elements
 */
int NScountList(NS_LinkedList *list)
{
  NS_LinkItem *current;
  int count=0;

  current = list->start;
  while(current != NULL)
  {
    current = current->next;
    count++;
  }
  return count;
}

/*
 * NSitemLookup()
 *
 * Returns a NULL terminated list of all the matchin entries
 */
void **NSitemLookup(NS_LinkedList *list,void *key,int (*EQUAL)(void*,void*))
{
  NS_LinkItem *current;
  int count=0;
  void **result;

  current = list->start;
  while(current != NULL)
  {
    if (EQUAL(key,current->content))
      count++;
    current=current->next;
  }
  result = (void**)calloc(count+1,sizeof(void*));
  count = 0;
  current = list->start;
  while(current != NULL)
  {
    if (EQUAL(key,current->content))
    {
      result[count] = current->content;
      count++;
    }
    current=current->next;
  }
  result[count] = NULL;
  return result;
}

/*
 * NSitemDelete()
 *
 * Deletes all the corresponding items
 */
void NSitemDelete(NS_LinkedList *list,void *key,
                int (*EQUAL)(void*,void*),
                void (*FREE)(void*))
{
  NS_LinkItem *t;
  
  t = list->start;
  while(t != NULL)
  {
    NS_LinkItem *tmp;

    if (!EQUAL(key,t->content))
    {
      t = t->next;
      continue;
    }
    tmp =t->next;
    
    if (t->prev == NULL)
      list->start = t->next;
    else
      t->prev->next = t->next;

    if (t->next != NULL)
      t->next->prev = t->prev;
  
    FREE(t->content);
    free(t);
    t = tmp;
  }
}

/*
 * NSitemInsert
 *
 */
void NSitemInsert(NS_LinkedList *list,void *value)
{
  NS_LinkItem *t;

  t = newNSLinkItem(value);
  t->next = list->start;
  if (t->next != NULL)
    t->next->prev = t;
  t->prev = NULL;
  list->start = t;
}
