/*****************************************************************/
/*      historydesc.c                                            */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"

/*
 * freeWorkloadHistory()
 */
void freeWorkloadHistory(NS_WorkloadHistory *d)
{
  if (d == NULL)
    return;
  free(d);
}

/*
 * freeNetworkHistory()
 */
void freeNetworkHistory(NS_NetworkHistory *d)
{
  if (d == NULL)
    return;
  free(d);
}

/*
 * newWorkloadHistory()
 */
NS_WorkloadHistory *newWorkloadHistory()
{
  return (NS_WorkloadHistory *)calloc(1,sizeof(NS_WorkloadHistory));
}

/*
 * newNetworkHistory()
 */
NS_NetworkHistory *newNetworkHistory()
{
  return (NS_NetworkHistory *)calloc(1,sizeof(NS_NetworkHistory));
}

/*
 * sendNetworkHistory()
 *
 * Sends a network History on the network
 */
int sendNetworkHistory(NS_Communicator *comm, NS_NetworkHistory* h)
{
  if (sendInt(comm,h->latency) == -1)
    return -1;
  if (sendInt(comm,h->bandwidth) == -1)
    return -1;
  if (sendInt(comm,h->time) == -1)
    return -1;
  return 1;
}

/*
 * sendWorkloadHistory()
 *
 * Sends a workload History on the network
 */
int sendWorkloadHistory(NS_Communicator *comm, NS_WorkloadHistory* h)
{
  if (sendInt(comm,h->w) == -1)
    return -1;
  if (sendInt(comm,h->time) == -1)
    return -1;
  return 1;
}

/*
 * recvNetworkHistory()
 *
 * receives a Network history from a communicator
 */
NS_NetworkHistory *recvNetworkHistory(NS_Communicator *comm)
{
  NS_NetworkHistory *new;
  new = newNetworkHistory();
  if (recvInt(comm,&(new->latency)) == -1)
  {
    free(new);
    return NULL;
  }
  if (recvInt(comm,&(new->bandwidth)) == -1)
  {
    free(new);
    return NULL;
  }
  if (recvInt(comm,&(new->time)) == -1)
  {
    free(new);
    return NULL;
  }
  return new;
}

/*
 * recvWorkloadHistory()
 *
 * receives a workload history from a communicator
 */
NS_WorkloadHistory *recvWorkloadHistory(NS_Communicator *comm)
{
  NS_WorkloadHistory *new;
  new = newWorkloadHistory();
  if (recvInt(comm,&(new->w)) == -1)
  {
    free(new);
    return NULL;
  }
  if (recvInt(comm,&(new->time)) == -1)
  {
    free(new);
    return NULL;
  }
  return new;
}


/*
 * addToWorkloadHistory
 */
void addToWorkloadHistory(NS_WorkloadHistory *wh,int workload, int date)
{
  wh->w = workload;
  wh->time = date;
}

/*
 * addToNetworkHistory
 */
void addToNetworkHistory(NS_NetworkHistory *nh,int latency,int bandwidth, int date)
{
  nh->latency = latency;
  nh->bandwidth = bandwidth;
  nh->time = date;
}
