/*****************************************************************/
/*      general.c                                                */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "netsolvearch.h"
#ifndef WIN32
#include <sys/types.h>
#include <unistd.h>
#include <netdb.h>
#include <pwd.h>

#else

#define MAX_AGENT_NAME 127
static char sAgent[MAX_AGENT_NAME+1]="";
#endif

/*
 * getArch()
 *
 * returns the code fo this machine architecture
 */
int getArch()
{
  struct NS_archtypes current;
  int i=1;

  current = archs[i];
  while(strcmp(current.archname,"") != 0)
  {
    if (strstr(NETSOLVE_ARCH, current.archname) != NULL)
    {
      return (current.archnum);
    }
    i++;
    current = archs[i];
  }

  ns_errno = NetSolveUnknownDataFormat;
  return -1;
}

#ifndef WIN32
/*
 * getNetSolveRoot()
 */
char *getNetSolveRoot()
{
  return strdup(NETSOLVE_ROOT);
}
#endif

/*
 * getAgentName()
 */
/* Unix version */
#ifndef WIN32
char *getNetSolveAgent()
{
  char *e = getenv("NETSOLVE_AGENT");
  if (e == NULL)
    return NULL;
  else 
    return strdup(e);
}
#else

char *getNetSolveAgent()
{
  FILE *fp;
  char myBuffer[MAX_AGENT_NAME+1];
  char *p;
  
  /* Have we already read the agent name? */
  if (sAgent[0] != '\0')
    return(strdup(sAgent));

  /* Open the Netsolve.ini file */
  if ((fp = fopen("Netsolve.ini", "r")) == NULL)
    return(NULL);
  
  /* Read a line from the file */
  if (fgets(myBuffer, MAX_AGENT_NAME, fp) == NULL)
    return(NULL);
          
  /* Close the file */
  fclose(fp);

  /* Parse out the agent name */
  if ((p = strstr(myBuffer, "=")) == NULL)
    return(NULL);
  
  p++;

  /* skip the "=" */

  strcpy(sAgent, p);
  if (sAgent[strlen(sAgent)-1] == '\n')
    sAgent[strlen(sAgent)-1] = '\0';        /* Overwrite the newline */

  return(strdup(sAgent));
}
#endif

#ifndef WIN32
/*
 * getUserName()
 */
char *getUserName()
{
  uid_t id;
  struct passwd *pe;
  char * username;

  id = geteuid();
  pe = getpwuid(id);
  if (pe == NULL)
  {
    fprintf(STDERR "Impossible to getpwuid()\n");
    return NULL;
  }
 
  username = strdup(pe->pw_name);
  return username;
}

/*
 * getHostName()
 */

char *getHostName()
{
  char buf[256];
  struct hostent * h;
  int status;

  status = gethostname(buf, 256);

  if(status == -1){
    fprintf(STDERR "gethostname() failed\n");
    return NULL;
  }

  h = gethostbyname(buf);

  if(h == NULL){
    fprintf(STDERR "gethostbyname() failed\n");
    return NULL;
  }

  return strdup(h->h_name);
}
  
#endif

char *Ctime(time_t *t){
char *retval;

  retval = (char *)ctime(t);

  retval[strlen(retval)-1] = '\0';

  return retval;
}

/* int ns_errmsg(char * filename, int lineno, FILE *stream, const char *format, ...){
  va_list arglist;

  fprintf("NS:%s:%d: ", filename, lineno);

  va_start(arglist, format);
  return vfprintf(stream, format, arglist);
  va_end(arglist);
} */
