/*****************************************************************/
/*      process_problems.c                                       */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/

#include "core.h"
#include "codegenerator.h"
#include "mnemonics.h"
#include "expressions.h"
#include "netsolveutil.h"

/*
 * processProblem()
 */

int processProblem(NS_ProblemDesc **pd, NS_ProblemDescAddendum **pdadd,
            char *filename, char *shortfile)
{
  NS_ProblemDesc *newpd;
  NS_ProblemDescAddendum *newpdadd;

  newpd = newProblemDesc();
  newpdadd = (NS_ProblemDescAddendum*)calloc(1,sizeof(NS_ProblemDescAddendum));
  
  /* Parse the file and update the initcode file */
  newpd->file = strdup(shortfile);

  /**********************
   **  @PROBLEM <name> **
   **********************/
  if (parsePROBLEM(newpd,newpdadd,filename) == -1)
    return -1;

  /***********************
   **  @FUNCTION <name> **
   ***********************/
  if (parseFUNCTION(newpd,newpdadd,filename) == -1)
    return -1;

  /**********************
   **  @INCLUDE <name> **
   **********************/
  if (parseINCLUDE(newpd,newpdadd,filename) == -1)
    return -1;

  /********************
   **  @DASHI <name> **
   ********************/
  if (parseDASHI(newpd,newpdadd,filename) == -1)
    return -1;

  /******************
   **  @LIB <name> **
   ******************/
  if (parseLIB(newpd,newpdadd,filename) == -1)
    return -1;

  /***********************
   **  @LANGUAGE <lang> **
   ***********************/
  if (parseLANGUAGE(newpd,newpdadd,filename) == -1)
    return -1;

  /********************
   **  @MAJOR <lang> **
   ********************/
  if (parseMAJOR(newpd,newpdadd,filename) == -1)
    return -1;

  /*******************
   **  @PATH <path> **
   *******************/
  if (parsePATH(newpd,newpdadd,filename) == -1)
    return -1;
 
  /**************************
   **  @DESCRIPTION <text> **
   **************************/
  if (parseDESCRIPTION(newpd,newpdadd,filename) == -1)
    return -1;
 
  /********************
   **  @INPUT <text> **
   ********************/
  if (parseINPUT(newpd,newpdadd,filename) == -1)
    return -1;
 
  /********************
   **  @OUTPUT <text> **
   ********************/
  if (parseOUTPUT(newpd,newpdadd,filename) == -1)
    return -1;
 
  /****************************
   **  @MATLAB_MERGE <#> <#> **
   ****************************/
  if (parseMATLAB_MERGE(newpd,newpdadd,filename) == -1)
    return -1;

  /*************************
   **  @CUSTOMIZED <name> **
   *************************/
  if (parseCUSTOMIZED(newpd,newpdadd,filename) == -1)
    return -1;

  /*************************
   **  @COMPLEXITY <string> **
   *************************/
  if (parseCOMPLEXITY(newpd,newpdadd,filename) == -1)
    return -1;

  /***********************
   **  @CALLINGSEQUENCE **
   ***********************/
  if (parseCALLINGSEQUENCE(newpd,newpdadd,filename) == -1)
    return -1;

  /************
   **  @CODE **
   ************/
  if (parseCODE(newpd,newpdadd,filename) == -1)
    return -1;
  
  /* Finalize the init code file */
  fprintf(initcodefile,"  addProblem(pb_desc);\n}\n\n");

  *pd = newpd;
  *pdadd = newpdadd;

  return 1;
}

