/*****************************************************************/
/*      generate_makefile.c                                      */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/

#include <unistd.h>
#include "core.h"
#include "codegenerator.h"
#include "mnemonics.h"
#include "expressions.h"
#include "netsolveutil.h"

/*
 * generateMakefile()
 */
int generateMakefile(int filesnumber,char **files,
                 char **shortfiles, NS_DescFileAttributes **attrs)
{
  char *currentfile;
  NS_DescFileAttributes *currentattr;
  /* char *arch; */
  char makefile[256];
  char mf_num_lib[256];
  int i = 0;
  int j,k;
  FILE *f;
  FILE *fnum;
  int *ftps;

   
  /* arch = strdup("NETSOLVE_ARCH"); */
  
  sprintf(makefile,"%s/src/%s",root,TARGETMAKEFILE);
  sprintf(mf_num_lib, "%s/src/%s", root, MAKEFILE_NUM_LIB);
   
  unlink(mf_num_lib);
   
  f = fopen(makefile,"w");
  if (f == NULL)
  {
    fprintf(stderr,"Impossible to open %s\n",makefile);
    exit(-1);
  }
  
  fprintf(f,"###################################################\n");
  fprintf(f,"#  Generated Makefile for computational modules   #\n");
  fprintf(f,"#  This file has been generated by code_generator #\n");
  fprintf(f,"###################################################\n\n");
   
  fprintf(f,"default:\tall\n");
   
  fprintf(f,"\ninclude ./Makefile.def");
  fprintf(f,"\ninclude ./%s\n", MAKEFILE_NUM_LIB);

  fprintf(f,"\n.SILENT:\n\n");

  fprintf(f,"\nall:\t");

  ftps = (int *)calloc(filesnumber,sizeof(int));
  for (i=0;i<filesnumber;i++)
  {
    fprintf(f," \\\n");
    if (noFTPRequired(attrs[i]))
      fprintf(f,"\t$(BINDIR)/service-%s ",shortfiles[i]);
    else
      ftps[i] = 1;
  }
   
  for (i=0;i<filesnumber;i++)
  {
    currentfile = shortfiles[i];
    currentattr = attrs[i];

    fprintf(f,"\n\n###\n");
    fprintf(f,"# Module : numerical-%s\n",currentfile);
    fprintf(f,"###\n");

    if (!strcmp(currentattr->customized,"NONE"))
    {
      /*
       * Generating the NetSolve and Globus module !!
       */
      if (!ftps[i])
        fprintf(f,"$(BINDIR)/service-%s : \\\n",currentfile);
      else
        fprintf(f,"./service-%s : \\\n",currentfile);
      fprintf(f,"\t\t$(UPF) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(DEPLIB%s) \\\n",currentfile);
      fprintf(f,"\t\t$(STANDARDSERVICEOBJ) \n");
      fprintf(f,"\t@echo Linking $@ ... ;\\\n");
      fprintf(f,"\t$(LINKER) $(LDFLAGS) $(UPF) \\\n");
      fprintf(f,"\t\t$(STANDARDSERVICEOBJ) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(F_FROM_C_LIB) \\\n");
      fprintf(f,"\t\t$(IBPLIB) $(AUTH_LIBS) $(LIBS) $(HBMLIB) $(ARCHDLIB) -o $@ \\\n");
    }
    else if (!strcmp(currentattr->customized,"GLOBUS"))
    {
     if (!ftps[i])
        fprintf(f,"$(BINDIR)/service-%s : \\\n",currentfile);
      else
        fprintf(f,"./service-%s : \\\n",currentfile);
      fprintf(f,"\t\t$(UPF) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(DEPLIB%s) \\\n",currentfile);
      fprintf(f,"\t\t$(GLOBUSSERVICEOBJ) \n");
      fprintf(f,"\t@echo Linking $@ ... ;\\\n");
      fprintf(f,"\t$(LINKER) $(LDFLAGS) $(UPF) \\\n");
      fprintf(f,"\t\t$(GLOBUSSERVICEOBJ) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(F_FROM_C_LIB) \\\n");
      fprintf(f,"\t\t$(IBPLIB) $(AUTH_LIBS) $(LIBS) $(HBMLIB) $(ARCHDLIB) -o $@ \\\n");
    }
    else if (!strcmp(currentattr->customized,"PETSC") )
    {
      if (!ftps[i])
        fprintf(f,"$(BINDIR)/service-%s : \\\n",currentfile);
      else
        fprintf(f,"./service-%s : \\\n",currentfile);
      fprintf(f,"\t\t$(UPF) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(DEPLIB%s) \\\n",currentfile);
      fprintf(f,"\t\t$(SCALAPACKSERVICEOBJ) \n");
      fprintf(f,"\t@echo Linking $@ ... ;\\\n");
      fprintf(f,"\tcd $(OBJDIR);\\\n");       
      fprintf(f,"\t$(LINKER) $(LDFLAGS) $(UPF) \\\n");
      fprintf(f,"\t\t$(PETSCSERVICEOBJ) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(F_FROM_C_LIB) \\\n");
      fprintf(f,"\t\t$(IBPLIB) $(AUTH_LIBS) $(LIBS) $(HBMLIB) $(ARCHDLIB) -o $@ \\\n");
    }
    else if (!strcmp(currentattr->customized,"SCALAPACK"))
    {
      if (!ftps[i])
        fprintf(f,"$(BINDIR)/service-%s : \\\n",currentfile);
      else
        fprintf(f,"./service-%s : \\\n",currentfile);
      fprintf(f,"\t\t$(UPF) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(DEPLIB%s) \\\n",currentfile);
      fprintf(f,"\t\t$(SCALAPACKSERVICEOBJ) \n");
      fprintf(f,"\t@echo Linking $@ ... ;\\\n");
      fprintf(f,"\tcd $(OBJDIR);\\\n");       
      fprintf(f,"\t$(LINKER) $(LDFLAGS) $(UPF) \\\n");
      fprintf(f,"\t\t$(SCALAPACKSERVICEOBJ) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(F_FROM_C_LIB) \\\n");
      fprintf(f,"\t\t$(IBPLIB) $(AUTH_LIBS) $(LIBS) $(HBMLIB) $(ARCHDLIB) -o $@ \\\n");
    }
    else if (!strcmp(currentattr->customized,"ITER_SOLVE"))
    {
      if (!ftps[i])
        fprintf(f,"$(BINDIR)/service-%s : \\\n",currentfile);
      else
        fprintf(f,"./service-%s : \\\n",currentfile);
      fprintf(f,"\t\t$(UPF) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(DEPLIB%s) \\\n",currentfile);
      fprintf(f,"\t\t$(ITERSOLVESERVICEOBJ) \n");
      fprintf(f,"\t@echo Linking $@ ... ;\\\n");
      fprintf(f,"\tcd $(OBJDIR);\\\n");
      fprintf(f,"\t$(LINKER) $(LDFLAGS) $(UPF) \\\n");
      fprintf(f,"\t\t$(ITERSOLVESERVICEOBJ) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(F_FROM_C_LIB) \\\n");
      fprintf(f,"\t\t$(IBPLIB) $(AUTH_LIBS) $(LIBS) $(HBMLIB) $(ARCHDLIB) -o $@ \\\n");
    }
    else if (!strcmp(currentattr->customized,"CONDOR"))
    {
      if (!ftps[i])
        fprintf(f,"$(BINDIR)/service-%s : \\\n",currentfile);
      else
        fprintf(f,"./service-%s : \\\n",currentfile);
      fprintf(f,"\t\t$(UPF) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(DEPLIB%s) \\\n",currentfile);
      fprintf(f,"\t\t$(CONDORSERVICEOBJ) \n");
      fprintf(f,"\t@echo Linking $@ ... ;\\\n");
      fprintf(f,"\tcd $(OBJDIR);\\\n");
      fprintf(f,"\tcondor_compile $(LINKER) $(LDFLAGS) $(UPF) \\\n");
      fprintf(f,"\t\t$(CONDORSERVICEOBJ) \\\n");
      fprintf(f,"\t\t$(OBJDIR)/numerical-%s.o \\\n",currentfile);
      fprintf(f,"\t\t$(F_FROM_C_LIB) \\\n");
      fprintf(f,"\t\t$(IBPLIB) $(AUTH_LIBS) $(LIBS) $(HBMLIB) $(ARCHDLIB) -o $@ \\\n");
    }

    /* Putting the libs at the end of the file Makefile-num-lib */
     
    fnum = fopen(mf_num_lib,"a");
    if (fnum == NULL)
    {
      fprintf(stderr,"Impossible to create file '%s'\n",mf_num_lib);
      fclose(f);
      free(ftps);
      return -1;
    }
    fprintf(fnum,"\nLIB%s = ",currentfile);
    for (j=0;j<currentattr->nb_libs;j++)
    {
      if (!strncmp(currentattr->libs[j],"FTP://",6))
        fprintf(fnum,"\\\n\t    ./%s ",lastInPath(currentattr->libs[j]));
      else
        fprintf(fnum,"\\\n\t    %s ",currentattr->libs[j]);
    }
    fprintf(fnum,"\n");

    fprintf(fnum,"\nDEPLIB%s = ",currentfile);
    for (j=0;j<currentattr->nb_libs;j++)
    {
      if (currentattr->libs[j][0] != '-') /* takes care of -l... */
      {
        if (!strncmp(currentattr->libs[j],"FTP://",6))
          fprintf(fnum,"\\\n\t    ./%s ",lastInPath(currentattr->libs[j]));
        else
          fprintf(fnum,"\\\n\t    %s ",currentattr->libs[j]);
      }
    }
    fprintf(fnum,"\n\n");

    /* Take care of the FTP */
    for (j=0;j<currentattr->nb_libs;j++)
    {
      if (strncmp(currentattr->libs[j],"FTP://",6))
        continue;

      fprintf(fnum,"./%s:\n",lastInPath(currentattr->libs[j]));
      fprintf(fnum,"\t$(NETSOLVE_ROOT)/src/ftpdownload ");
      fprintf(fnum,"%s ",getFTPHost(currentattr->libs[j]));
      fprintf(fnum,"%s ",getFTPPath(currentattr->libs[j]));
      fprintf(fnum,"%s\n\n",getFTPFile(currentattr->libs[j]));
    }
    fclose(fnum);
     
    fprintf(f,"\t\t$(LIB%s) \n\n",currentfile);

    fprintf(f,"$(OBJDIR)/numerical-%s.o : \\\n",currentfile);
    fprintf(f,"\t\t$(NETSOLVE_ROOT)/src/Server/numerical-%s.c \n",currentfile);

    fprintf(f,"\t@echo Generating $@ ... ;\\\n");
    fprintf(f,"\t$(CC) $(NS_CFLAGS) \\\n");
    for (k=0;k<currentattr->nb_dashis;k++)
      fprintf(f,"\t\t-I%s \\\n",currentattr->dashis[k]);
    fprintf(f,"\t\t -DDUMMYUPF -c \\\n");
    fprintf(f,"\t\t $(NETSOLVE_ROOT)/src/Server/numerical-%s.c -o $@ \n\n",
                      currentfile);
  }

  fprintf(f,"\ninclude $(NETSOLVE_ROOT)/src/Makefile.sample_software\n");
  fprintf(f,"\ninclude $(NETSOLVE_ROOT)/src/Makefile.object\n");

  fclose(f);
  free(ftps);
  return 1;
}

/*
 * noFTPRequired()
 */
int noFTPRequired(NS_DescFileAttributes *attr)
{
  int j;

  for (j=0;j<attr->nb_libs;j++)
    if (!strncmp(attr->libs[j],"FTP://",6))
      return 0;
  return 1;
}

/*
 * getFTPHost()
 */
char *getFTPHost(char *line)
{
  char *tmp = strdup(&(line[6]));
  char *ptr; 
  char *result;
   
  ptr = tmp;
  while (*ptr != '/')
    ptr++;
  *ptr = '\0';
  
  result = strdup(tmp);
  free(tmp);
  return result;
}

/*
 * getFTPFile()
 */
char *getFTPFile(char *line)
{
  char *tmp = strdup(line);
  
  return strdup(lastInPath(tmp));
}

/*
 * getFTPPath()
 */
char *getFTPPath(char *line)
{
  char *tmp = strdup(&(line[6]));
  char *ptr;  
  char *result;
  char *tmp2;
  
  ptr = tmp;
  while (*ptr != '/')
    ptr++;
  ptr++;
  tmp2 = strrchr(ptr,'/');
  *tmp2='\0';
  result = strdup(ptr);
  free(tmp);
  return result;
}


