/*****************************************************************/
/*      netsolvesendrequest_sequence.c                           */
/*      Henri Casanova                                           */
/*      Dieter Bachmann                                          */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"
#include "client2server.h"
#include <signal.h>
#include <time.h>

/*
 * netsolveSendRequest_sequence()
 *
 * This function send an asynchronous request to NetSolve.
 */
NS_RequestDesc *netsolve_sequence_SendRequest(NS_Node *top_node)
{
  int status;
  NS_RequestDesc *rd;

  NS_Node *tmp_node = top_node;

  /********************************************/
  /* determine the input/output/problem sizes */
  /********************************************/
 
  while(tmp_node!=NULL){
      status = determineSizes(tmp_node->pd, tmp_node->pd->input_objects, tmp_node->pd->output_objects,
			      &tmp_node->input_size, &tmp_node->output_size, 
			      &tmp_node->problem_size);
      if (status == -1)
	  return NULL;
      tmp_node = tmp_node -> next;
  } /* for all nodes */

  /********************************************/
  /* Send the request to the system	      */
  /********************************************/
  rd = CP_sendJobRequest_sequence(top_node);
  if (rd == NULL)
      return NULL; 
  
  tmp_node = top_node;
  while(tmp_node!=NULL){
      
      /* Add the local information */
      rd->pd  = tmp_node->pd;
      rd->input = tmp_node->pd->input_objects;
      rd->output = tmp_node->pd->output_objects; 
      
      if (CS_sendInput(rd) == -1)  
	  {  
         if (ns_errno == NetSolveFileError) {
           free(rd);
           return NULL;
         }

         if (ns_errno == NetSolveAuthenticationError){
           free(rd);
           return NULL;
         }

         reportFailure(rd->IPaddr,rd->pd->nickname,
                       rd->request_id,HOST_ERROR);
         free(rd);
       /*fprintf(stderr, "NS:error while sending node:%d\n",tmp_node->id);*/
       return NULL;
	  } 

      tmp_node=tmp_node->next;
  } /* for all nodes */
  ns_errno = NetSolveOK;
  return rd;
} /* RequestDesc *netsolve_sequence_SendRequest(NS_Node *top_node) */

