/*****************************************************************/
/*      netsolvesendrequest.c                                    */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"
#include "client2server.h"
#include <signal.h>
#include <time.h>

/*
 * netsolveSendRequest()
 *
 * This function sends an asynchronous request to NetSolve.
 */
NS_RequestDesc *
netsolveSendRequest(int assignment, char * serverhostname,
                    NS_ProblemDesc *pd, NS_Object **input,
                    NS_Object **output)
{
  int status;
  int input_size, output_size, problem_size;
  NS_RequestDesc *rd;


  /* Sudesh: Commenting rd = newRequestDesc(), MemoryLeak */
  /* rd = newRequestDesc();  */
 

  if(assignment){
    while(1){
      rd = CP_sendJobAssignment(pd, getIPaddr(serverhostname));
      if (rd == NULL)
        return NULL;
      /* Add the local information */
      rd->input = input;
      rd->output = output;
  
      /* Send the input */
      if (CS_sendInput(rd) == -1) {
        if (ns_errno == NetSolveFileError) {
          free(rd);
          return NULL;
        }

        reportFailure(rd->IPaddr,rd->pd->nickname,
                      rd->request_id,HOST_ERROR);
      }
      else{
        break;
      }
    }
  }
  else{   /*== No Assignment ==*/

    /*== determine the input/output/problem sizes ==*/
    status = determineSizes(pd,input,output,
             &input_size,&output_size,&problem_size);
    if (status == -1)
      return NULL;

    /*== Send the request to the system ==*/
    while(1)
    {
      rd = CP_sendJobRequest(pd,input_size,output_size,problem_size);
      if (rd == NULL)
        return NULL;
      /* Add the local information */
      rd->input = input;
      rd->output = output;
  
#if defined (VIEW)
     fprintf(STDERR "Sending Input to Server %s\n", rd->hostname);
#endif
      if (CS_sendInput(rd) == -1) {
        if (ns_errno == NetSolveFileError) {
          free(rd);
          return NULL;
        }
        if (ns_errno == NetSolveAuthenticationError){
          free(rd);
          return NULL;
        }

        reportFailure(rd->IPaddr,rd->pd->nickname,
                      rd->request_id,HOST_ERROR);
        free(rd);
      }
      else
        break;
    }
  }
  
  ns_errno = NetSolveOK;
  return rd;
}
