/*****************************************************************/
/*      netsolve_sequence_blocking.c                             */
/*      Henri Casanova                                           */
/*      Dieter Bachmannn                                         */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"

/*
 * netsolve_sequence_Blocking()
 *
 * This function allows the user to perform a synchronous computation.
 * It returns either an error code, or with the result in the user's
 * workspace. This function is build on top of two other functions
 * that are also part of the client interfaceimplemented in this
 * directory.
 */

/* 
 * This functions allows to send multible requests to one server.
 */


int netsolve_sequence_Blocking(NS_Node *top_node,
                     int *elapsed)
{
  int status;
  NS_RequestDesc *rd;

  /***********************************/
  /* Sending an asynchronous request */
  /***********************************/

  rd = netsolve_sequence_SendRequest(top_node);
  if (rd == NULL){
      return -1;
      printf("no request description\n");
  }
  /****************************/
  /* Waiting for that request */
  /****************************/

  status = netsolveWaitRequest_sequence(top_node, &rd,elapsed);

  free(rd);
  return status;
}
