/*****************************************************************/
/*      netslinit.c                                              */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  netslinit()                                                  */
/*****************************************************************/

/*
 * netslinit() : does a few useful initializations
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "proxy.h"

int netslinit(char *agent)
{
  char *agent_name;

#if (defined(VIEW) || defined(DEBUG))
  fprintf(STDERR "Initializing NetSolve...\n");
#endif

  /* Get the agent name */
  if (agent == NULL)
  {  /* Get it from the environment */
    agent_name = getNetSolveAgent();
    if (agent_name == NULL)
    {
      ns_errno = NetSolveSetNetSolveAgent;
      return ns_errno;
    }
  }
  else 
    agent_name = strdup(agent);

#if defined(DEBUG)
  ns_printinfo();
  fprintf (STDERR "Agent name = %s\n", agent_name); fflush(stderr);
#endif

  /* Get the data format */
  my_data_format = getArch();
#if defined(DEBUG)
  ns_printinfo();
  fprintf (STDERR "Client data format = %d (from getArch())\n",
           my_data_format);
  fflush(stderr);
#endif
  if (my_data_format == -1)
  {
    ns_errno = NetSolveSetNetSolveArch;
    return ns_errno;
  }

  /* Start the proxy !!                         */
  /* proxy_pid, proxy_port are global variables */

#if defined(DEBUG)
  ns_printinfo();
  fprintf (STDERR "Starting the proxy ... startProxy()\n");
  fflush(stderr);
#endif

  if (startProxy("NetSolve",agent_name,&proxy_pid,&proxy_port) == -1) { 
    fprintf (STDERR "Error return from startProxy = %d\n", ns_errno);
    return ns_errno;
  }
 
#if (defined(VIEW) || defined(DEBUG))
  fprintf(STDERR "Initializing NetSolve Complete\n");
#endif
  return NetSolveOK;
}
