/*****************************************************************/
/*      CS_sendinput.c                                           */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2server.h"
#include "proxyjobdesc.h"
#include "proxy.h"

#include <signal.h>
#include <time.h>

/*
 *  CS_sendInput()
 *
 */
int CS_sendInput(NS_RequestDesc *rd)
{
  NS_Communicator *comm;
  int tag;
  int i;

  /********************************************/
  /* contact the server			      */
  /********************************************/
  comm = contactHost(NULL,rd->IPaddr,rd->port,rd->encoding);
  if (comm == NULL)
  {
    netsolvePerror("contactHost()");
    return -1;
  } 

  if (recvInt(comm, &tag) == -1)
  {
    endTransaction(comm);
    return -1;
  }

#ifdef KERBEROS5
  if (tag == NS_PROT_KRB5_AUTH_REQUIRED)
  {
    if (SendKerberos5Credentials (rd->hostname, comm) < 0)
    {
      ns_errno = NetSolveAuthenticationError;
      endTransaction (comm);
      return -1;
    }
    if (recvInt (comm, &tag) == -1)
    {
      endTransaction (comm);
      return -1;
    }
  }
  /*
   * check for authentication-specific error codes here
   * before falling through to the problem-specific error codes
   */
  if (tag == NS_PROT_AUTH_FAILED)
  {
    ns_errno = NetSolveAuthenticationError;
    endTransaction (comm);
    return -1;
  }
#endif

  if (tag == NS_PROT_KRB5_AUTH_REQUIRED)
  {
    ns_errno = NetSolveAuthenticationError;
    endTransaction (comm);
    return -1;
  }
  else if(tag != NS_PROT_ACCEPTED){
    ns_errno = NetSolveNotAllowed;
    endTransaction(comm);
    return -1;
  }

  /* Sending the request ID */
  if ((sendInt(comm,rd->request_id) == -1) ||
      (sendInt(comm,my_major) == -1))
  {
    endTransaction(comm);
    return -1;
  }

  /* Sending the objects */
  for (i=0;i<rd->pd->nb_input_objects;i++)
  {
  if (rd->pd->input_objects[i]->pass_back == FALSE) continue;

    if (sendObject(comm,rd->input[i]) == -1)
    {
      endTransaction(comm);
      return -1;
    }
  }
  endTransaction(comm);
  return 1;
}
