/*****************************************************************/
/*      CS_downloadoutput.c                                      */
/*      Henri Casanova                                           */
/*      Dieter Bachmann                                          */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#include <sys/socket.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>

/*
 * CS_downloadOutput()
 */
int CS_downloadOutput_sequence(NS_Node *top_node, NS_RequestDesc *rd, int *elapsed)
{
  int tag;
  NS_Communicator *comm;
  char *stdoutbuf;
  int i;
  NS_Node *tmp_node;

  /* contact the server */
  comm = contactHost(NULL,rd->IPaddr,rd->port,rd->encoding);
  if (comm == NULL)
    return -1;

  /* Receive the elapsed time */
  if (recvInt(comm,elapsed) == -1)
  {
    endTransaction(comm);
    return -1;
  }

  /* Receive the standard output */
  if (recvString(comm,&stdoutbuf) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  fprintf(STDOUT stdoutbuf);
  free(stdoutbuf);
  
  /* receive the status */
  if (recvInt(comm,&tag) == -1)
  {
    endTransaction(comm);
    return -1;
  }

  if (tag != NS_PROT_SOLVED)
  {
    endTransaction(comm);
    switch(tag)
    {
      case NS_PROT_INTERNAL_FAILURE:
        ns_errno = NetSolveServerError;
        break;
      case NS_PROT_BAD_VALUES:
        ns_errno = NetSolveBadValues;
        break;
      case NS_PROT_DIM_MISMATCH:
        ns_errno = NetSolveDimensionMismatch;
        break;
      case NS_PROT_NO_SOLUTION:
        ns_errno = NetSolveNoSolution;
        break;
      default:
        ns_errno = NetSolveProtocolError;
        break;
    }
    return -1;
  }
  
  tmp_node = top_node;
  while(tmp_node !=NULL){
      for (i=0;i<tmp_node->pd->nb_output_objects;i++) {
	  
	      if (tmp_node->pd->output_objects[i]->pass_back == TRUE)
		  if (recvObject(comm,tmp_node->pd->output_objects[i]) == -1)
		      {
			  endTransaction(comm);
			  return -1;
		      }
      }
      tmp_node = tmp_node->next;
  }
  endTransaction(comm);
  ns_errno = NetSolveOK;
  return 1;
}
  
