/*****************************************************************/
/*      CS_downloadoutput.c                                      */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2server.h"
#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#include <sys/socket.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>

/*
 * CS_downloadOutput()
 */
int CS_downloadOutput(NS_RequestDesc *rd, int *elapsed)
{
  int tag;
  NS_Communicator *comm;
  char *stdoutbuf;
  int i;

  /* contact the server */
  comm = contactHost(NULL,rd->IPaddr,rd->port,rd->encoding);
  if (comm == NULL)
    return -1;

  /* Receive the elapsed time */
  if (recvInt(comm,elapsed) == -1)
  {
    endTransaction(comm);
    return -1;
  }

  /* Receive the standard output */
  if (recvString(comm,&stdoutbuf) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  fprintf(STDOUT stdoutbuf);
  free(stdoutbuf);
  
  /* receive the status */
  if (recvInt(comm,&tag) == -1)
  {
    endTransaction(comm);
    return -1;
  }

  if (tag != NS_PROT_SOLVED)
  {
    endTransaction(comm);
    switch(tag)
    {
      case NS_PROT_INTERNAL_FAILURE:
        ns_errno = NetSolveServerError;
        break;
      case NS_PROT_BAD_VALUES:
        ns_errno = NetSolveBadValues;
        break;
      case NS_PROT_DIM_MISMATCH:
        ns_errno = NetSolveDimensionMismatch;
        break;
      case NS_PROT_NO_SOLUTION:
        ns_errno = NetSolveNoSolution;
        break;
      default:
        ns_errno = NetSolveProtocolError;
        break;
    }
    return -1;
  }

  for (i=0;i<rd->pd->nb_output_objects;i++)
  {
    if (rd->pd->output_objects[i]->pass_back == FALSE) continue;
    if (recvObject(comm,rd->output[i]) == -1)
    {
      endTransaction(comm);
      return -1;
    }
  }
  endTransaction(comm);
  ns_errno = NetSolveOK;
  return 1;
}
  
