#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 * CP_storeHandle()
 *
 */
int CP_storeHandle(DSI_OBJECT* dsi_obj)
{
  int ns_errno;
  NS_Communicator *comm;

  /************************************/
  /* Contacting the proxy		*/
  /************************************/

  comm = contactProxy(1);
  if (comm == NULL)
  {
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Sending */
  if (sendInt(comm,NS_PROT_STORE_HANDLE) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  if(sendDsiObj(comm, dsi_obj)	== -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  endTransaction(comm);

  ns_errno = NetSolveOK;
  return 1;
}
