/*****************************************************************/
/*      CP_sendjobrequest.c                                      */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#include <signal.h>
#include <time.h>

/*
 *  CP_sendjobrequest()
 *
 */
NS_RequestDesc *CP_sendJobRequest(NS_ProblemDesc *pd,int input_size,
                  int output_size, int problem_size)
{
  NS_RequestDesc *rd;
  NS_Communicator *comm;
  int port;
  unsigned int IPaddr;
  int data_format;
  char *hostname;
  int NS_errno;


  /********************************************/
  /* contact the proxy 			      */
  /********************************************/
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return NULL;
  } 

  /* Sending */
  if ((sendInt(comm,NS_PROT_SEND_REQUEST) == -1)              ||
      (sendProblemDesc(comm,pd) == -1) ||
      (sendInt(comm,input_size) == -1)       ||
      (sendInt(comm,output_size) == -1)      ||
      (sendInt(comm,problem_size) == -1))
  {
    netsolvePerror("");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  if (recvInt(comm,&NS_errno) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  } 
  if (NS_errno != NetSolveOK) /* ERROR */
  {
    endTransaction(comm);
    ns_errno = NS_errno;
    return NULL;
  }

  rd = newRequestDesc();
  rd->pd = pd;

  /* Receive the proxy request_id */
  if ((recvInt(comm,&(rd->request_id)) == -1) ||
     (recvInt(comm,&(rd->predicted_time)) == -1) ||
     (recvInt(comm,&(rd->start_time)) == -1))
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  /* receive the location of the server */
  if ((recvIPaddr(comm,&IPaddr) == -1) ||
      (recvString(comm,&hostname) == -1) ||
      (recvInt(comm,&port) == -1) ||
      (recvInt(comm,&data_format) == -1))
  {
    netsolvePerror("");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }
  rd->hostname = hostname;
  rd->IPaddr = IPaddr;
  rd->port = port;
  if (data_format == my_data_format)
    rd->encoding = DATA_RAW;
  else 
    rd->encoding = DATA_XDR;

  endTransaction(comm);
  ns_errno = NetSolveOK;
  return rd;
}
