/*****************************************************************/
/*      CP_sendjobassignment.c                                   */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#include <signal.h>
#include <time.h>

/*
 *  CP_sendjobassignment()
 *
 */
NS_RequestDesc *CP_sendJobAssignment(NS_ProblemDesc *pd,NS_IPaddr_type IPaddr)
{
  NS_RequestDesc *rd;
  NS_Communicator *comm;
  int data_format;
  int newport;
  int NS_errno;

  /********************************************/
  /* contact the proxy 			      */
  /********************************************/
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return NULL;
  } 

  /* Sending */

  if ((sendInt(comm,NS_PROT_SEND_ASSIGNMENT) == -1)              ||
      (sendProblemDesc(comm,pd) == -1) ||
      (sendIPaddr(comm,&IPaddr) == -1))
  {
    netsolvePerror("");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  if (recvInt(comm,&NS_errno) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  } 
  if (NS_errno != NetSolveOK) /* ERROR */
  {
    endTransaction(comm);
    ns_errno = NS_errno;
    return NULL;
  }

  rd = newRequestDesc();
  rd->pd = pd;

  /* Receive the proxy request_id */
  if ((recvInt(comm,&(rd->request_id)) == -1) ||
     (recvInt(comm,&(rd->start_time)) == -1))
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  /* receive the data format */
  if ((recvInt(comm,&newport) == -1) ||
      (recvInt(comm,&data_format) == -1))
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }
  rd->IPaddr = IPaddr;
  rd->port = newport;
  if (data_format == my_data_format)
    rd->encoding = DATA_RAW;
  else 
    rd->encoding = DATA_XDR;

  endTransaction(comm);
  ns_errno = NetSolveOK;
  return rd;
}
