/*****************************************************************/
/*      CP_reportFailure.c                                       */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>

/*
 *  reportFailure()
 */
void CP_reportFailure(NS_IPaddr_type IPaddr, char *nickname, 
                      int ID,int error_type)
{
  NS_Communicator *comm;

  /* Contact the proxy */
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return;
  }

  /* Sending */
  if ((sendInt(comm,NS_PROT_SV_FAILURE) == -1) ||
      (sendIPaddr(comm,&IPaddr) == -1) ||
      (sendString(comm,nickname) == -1) ||
      (sendInt(comm,ID) == -1) ||
      (sendInt(comm,error_type) == -1))
  {
    endTransaction(comm);
    netsolvePerror("");
    ns_errno = NetSolveProxyError;
    return;
  }
  endTransaction(comm);

  ns_errno = NetSolveOK;
  return;
}
