/*****************************************************************/
/*      CP_netsolveinfo.c                                        */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 * CP_netsolveInfo()
 *
 */
int CP_netsolveInfo(char *nickname, NS_ProblemDesc **pd)
{
  int NS_errno;
  NS_Communicator *comm;

  /************************************/
  /* Contacting the proxy             */
  /************************************/

  comm = contactProxy(1);
  if (comm == NULL)
  {
    *pd = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Sending */
  if (sendInt(comm,NS_PROT_PROBLEM_INFO) == -1)
  {
    endTransaction(comm);
    *pd = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }
  if (sendString(comm,nickname) == -1)
  {
    endTransaction(comm);
    *pd = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    endTransaction(comm);
    *pd = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }
  if (NS_errno != NetSolveOK)
  {
    endTransaction(comm);
    *pd = NULL;
    ns_errno = NS_errno;
    return -1;
  }

  *pd = recvProblemDesc(comm);
  endTransaction(comm);

  if (*pd == NULL)
  {
    ns_errno = NetSolveProxyError;
    return -1;
  }
  
  ns_errno = NetSolveOK;
  return 1;
}
