/*****************************************************************/
/*      CP_getnumberofservers.c                                  */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 * CP_getNumberOfServers()
 *
 */
int CP_getNumberOfServers()
{
  NS_Communicator *comm;
  int nb_servers;
  int NS_errno;


  /************************************/
  /* Contacting the proxy             */
  /************************************/

  comm = contactProxy(1);
  if (comm == NULL)
  {
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Sending */
  if (sendInt(comm,NS_PROT_NB_SERVERS) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }
  if (NS_errno != NetSolveOK)
  {
    endTransaction(comm);
    ns_errno = NS_errno;
    return -1;
  }

  if (recvInt(comm,&nb_servers) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  endTransaction(comm);

  ns_errno = NetSolveOK;
  return nb_servers;
}
